/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class MagicInputStream
extends FilterInputStream {
    private String mimeType = null;
    private InputStream origIn;

    public MagicInputStream(InputStream in) throws IOException {
        super(in);
        this.origIn = in;
        int magicSize = this.getMagicSize();
        if (!in.markSupported()) {
            this.in = new BufferedInputStream(in, magicSize + 1);
        }
        this.identify();
    }

    public String getMimeType() throws IOException {
        return this.mimeType == null ? (this.origIn instanceof MagicInputStream ? ((MagicInputStream)this.origIn).getMimeType() : null) : this.mimeType;
    }

    protected int getMagicSize() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void identify() throws IOException {
        int magicSize = this.getMagicSize();
        byte[] magic = new byte[magicSize];
        int mlen = 0;
        try {
            this.in.mark(magicSize);
            for (int i = 0; i < magic.length; ++i) {
                if (this.in.read(magic, i, 1) < 1) {
                    break;
                }
                ++mlen;
            }
        }
        catch (IOException x) {
        }
        finally {
            this.in.reset();
        }
        this.mimeType = this.identify(magic, mlen);
    }

    protected abstract String identify(byte[] var1, int var2);
}

