/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.syxaw.util;

import fc.fp.syxaw.util.Log;
import fc.fp.util.xmlr.RefTree;
import fc.fp.util.xmlr.RefTreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class Util {
    public static final int COPY_BUF_SIZE = 4096;
    protected static LinkedList buffers = new LinkedList();
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Comparator STRINGS_BY_LENGTH = new Comparator(){

        public final int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            int l1 = o1.toString().length();
            int l2 = o2 != null ? o2.toString().length() : l1;
            return l1 != l2 ? l1 - l2 : o1.toString().compareTo(o2.toString());
        }
    };
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int copyStream(InputStream src, OutputStream dest) throws IOException {
        return Util.copyStream(src, dest, Long.MAX_VALUE);
    }

    public static int copyStream(InputStream src, OutputStream dest, long maxLeft) throws IOException {
        byte[] buffer = Util.getBuf();
        int total = 0;
        int count = 0;
        do {
            int maxchunk;
            if ((count = src.read(buffer, 0, maxchunk = (int)(maxLeft > (long)buffer.length ? (long)buffer.length : maxLeft))) <= 0) continue;
            dest.write(buffer, 0, count);
            total += count;
            maxLeft -= (long)count;
        } while (count > -1 && maxLeft > 0L);
        Util.freeBuf(buffer);
        return total;
    }

    public static byte[] copyAndDigestStream(InputStream src, OutputStream dest) throws IOException {
        byte[] buffer = Util.getBuf();
        int total = 0;
        int count = 0;
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException x) {
            Log.log("Message digest algorithm not found", 2);
        }
        do {
            if ((count = src.read(buffer)) <= 0) continue;
            sha.update(buffer, 0, count);
            dest.write(buffer, 0, count);
            total += count;
        } while (count > -1);
        Util.freeBuf(buffer);
        return sha.digest();
    }

    private static synchronized byte[] getBuf() {
        if (buffers.size() > 0) {
            return (byte[])buffers.removeFirst();
        }
        return new byte[4096];
    }

    private static synchronized void freeBuf(byte[] buf) {
        buffers.addLast(buf);
    }

    public static int arrayLookup(int[] ar, int keystart, int keyend, int forbidden) {
        for (int i = 0; ar != null && i < ar.length; ++i) {
            if (ar[i] < keystart || ar[i] >= keyend || ar[i] == forbidden) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLookup(int[] ar, int keystart, int keyend) {
        for (int i = 0; ar != null && i < ar.length; ++i) {
            if (ar[i] < keystart || ar[i] >= keyend) continue;
            return i;
        }
        return -1;
    }

    public static String format(String s, int width) {
        return Util.format(s, width, ' ');
    }

    public static String format(String s, int width, char filler) {
        StringBuffer buf = new StringBuffer();
        if (s == null) {
            s = "(null)";
        }
        int strlen = s.length();
        int fill = Math.abs(width) - strlen;
        if (fill > 0 && width < 0) {
            while (fill-- > 0) {
                buf.append(filler);
            }
        }
        buf.append(s);
        if (fill > 0 && width > 0) {
            while (fill-- > 0) {
                buf.append(filler);
            }
        }
        return buf.toString();
    }

    public static final boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static final String nullToEmpty(String s) {
        return s != null ? s : "";
    }

    public static void loadConfiguration(String file) throws IOException {
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(file);
        p.load(in);
        in.close();
        for (String string : p.keySet()) {
            System.setProperty(string, p.getProperty(string));
        }
    }

    public static void delTree(File f) throws IOException {
        Util.delTree(f, true, null);
    }

    public static void delTree(File f, boolean delRoot) throws IOException {
        Util.delTree(f, delRoot, null);
    }

    public static void delTree(File f, boolean delRoot, FilenameFilter fi) throws IOException {
        if (f.isDirectory()) {
            File[] entries = f.listFiles();
            for (int i = 0; i < entries.length; ++i) {
                Util.delTree(entries[i], true, fi);
            }
        }
        if (delRoot && (fi == null || fi.accept(f.getParentFile(), f.getName())) && !f.delete()) {
            throw new IOException("Can't delete " + f);
        }
    }

    public static String getHexString(byte[] v) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            sb.append(hexDigits[v[i] >> 4 & 0xF]);
            sb.append(hexDigits[v[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] getBytesFromHexString(String val) {
        if (val.length() == 0) {
            return new byte[0];
        }
        if (val.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid length");
        }
        byte[] storage = new byte[val.length() / 2];
        for (int i = 0; i < val.length(); i += 2) {
            storage[i / 2] = (byte)Integer.parseInt(val.substring(i, i + 2), 16);
        }
        return storage;
    }

    public static String base64toBase64Mod(String b64) {
        return b64.replace('+', '-').replace('/', '_').replace('=', ' ').trim();
    }

    public static String baseMod64toBase64(String b64mod) {
        if (b64mod.length() % 3 == 1) {
            b64mod = b64mod + "==";
        } else if (b64mod.length() % 3 == 2) {
            b64mod = b64mod + "=";
        }
        return b64mod.replace('-', '+').replace('_', '/');
    }

    public static void statTree(RefTree t) {
        long[] counters = new long[3];
        Util.statTree(t.getRoot(), counters);
        Log.log("Tree stats (total,nrefs,trefs)=", 5, Arrays.toString(counters));
    }

    protected static void statTree(RefTreeNode n, long[] counters) {
        counters[0] = counters[0] + 1L;
        counters[1] = counters[1] + (n.isNodeRef() ? 1L : 0L);
        counters[2] = counters[2] + (n.isTreeRef() ? 1L : 0L);
        Iterator i = n.getChildIterator();
        while (i.hasNext()) {
            Util.statTree((RefTreeNode)i.next(), counters);
        }
    }

    public static final String encodeStr(String s) {
        StringBuffer sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch < '!' || ch == '%') {
                if (sb == null) {
                    sb = new StringBuffer(2 * s.length());
                    sb.append(s.substring(0, i));
                }
                sb.append("%" + Util.getHexString(new byte[]{(byte)ch}));
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb != null ? sb.toString() : s;
    }

    public static final String decodeStr(String s) {
        StringBuffer sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '%') {
                if (sb == null) {
                    sb = new StringBuffer(2 * s.length());
                    sb.append(s.substring(0, i));
                }
                sb.append(new String(Util.getBytesFromHexString(s.substring(i + 1, i + 3))));
                i += 2;
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb != null ? sb.toString() : s;
    }

    public static String[] split(String s, char ch) {
        if (s == null) {
            return null;
        }
        int count = 1;
        int i = -1;
        while ((i = s.indexOf(ch, i + 1)) != -1) {
            ++count;
        }
        String[] split = new String[count];
        int item = 0;
        int start = 0;
        int end = 0;
        do {
            if ((end = s.indexOf(ch, start)) == -1) {
                split[item] = s.substring(start);
                continue;
            }
            split[item++] = s.substring(start, end);
            start = end + 1;
        } while (end != -1);
        return split;
    }

    public static final String[] splitWords(String s) {
        int cstart = -1;
        int len = s.length();
        LinkedList<String> l = new LinkedList<String>();
        if (s == null) {
            return null;
        }
        for (int pos = 0; pos < len; ++pos) {
            char ch = s.charAt(pos);
            if (cstart < 0) {
                if (ch == '\n' || Character.isSpaceChar(ch)) continue;
                cstart = pos;
                continue;
            }
            if (ch != '\n' && !Character.isSpaceChar(ch)) continue;
            l.add(s.substring(cstart, pos));
            cstart = -1;
        }
        if (cstart >= 0) {
            l.add(s.substring(cstart));
        }
        return l.toArray(new String[l.size()]);
    }

    public static class ObjectHolder {
        private Object o;

        public ObjectHolder(Object o) {
            this.o = o;
        }

        public ObjectHolder(boolean b) {
            this.o = new Boolean(b);
        }

        public Object get() {
            return this.o;
        }

        public boolean booleanValue() {
            return (Boolean)this.o;
        }

        public int intValue() {
            return (Integer)this.o;
        }

        public String stringValue() {
            return (String)this.o;
        }

        public void set(Object o) {
            this.o = o;
        }
    }

    public static abstract class DelayedInputStream
    extends InputStream {
        protected InputStream in = null;
        private boolean hasStream = false;
        private IOException delayedEx = null;

        protected boolean needStream(boolean needsData) throws IOException {
            final PipedOutputStream out = new PipedOutputStream();
            this.in = new PipedInputStream(out);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DelayedInputStream.this.stream(out);
                    }
                    catch (IOException x) {
                        Log.log("IOExcept in delayed producer, bubbling up...", 3, x);
                        DelayedInputStream.this.delayedEx = x;
                    }
                    finally {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }.start();
            return true;
        }

        protected abstract void stream(OutputStream var1) throws IOException;

        protected void streamDone() {
        }

        public int available() throws IOException {
            this.checkException();
            if (!this.hasStream) {
                this.hasStream = this.needStream(false);
            }
            return this.in.available();
        }

        public void close() throws IOException {
            this.checkException();
            this.streamDone();
            if (this.in != null) {
                this.in.close();
            }
        }

        public synchronized void mark(int readlimit) {
            try {
                if (!this.hasStream) {
                    this.hasStream = this.needStream(false);
                }
            }
            catch (IOException x) {
                this.delayedEx = x;
                return;
            }
            this.in.mark(readlimit);
        }

        public boolean markSupported() {
            try {
                if (!this.hasStream) {
                    this.hasStream = this.needStream(false);
                }
            }
            catch (IOException x) {
                this.delayedEx = x;
                return false;
            }
            return this.in.markSupported();
        }

        public int read() throws IOException {
            this.checkException();
            if (!this.hasStream) {
                this.hasStream = this.needStream(true);
            }
            return this.in.read();
        }

        public int read(byte[] b) throws IOException {
            this.checkException();
            if (!this.hasStream) {
                this.hasStream = this.needStream(true);
            }
            return this.in.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.checkException();
            if (!this.hasStream) {
                this.hasStream = this.needStream(true);
            }
            return this.in.read(b, off, len);
        }

        public synchronized void reset() throws IOException {
            this.checkException();
            if (!this.hasStream) {
                this.hasStream = this.needStream(false);
            }
            this.in.reset();
        }

        public long skip(long n) throws IOException {
            this.checkException();
            if (!this.hasStream) {
                this.hasStream = this.needStream(false);
            }
            return this.in.skip(n);
        }

        private final void checkException() throws IOException {
            if (this.delayedEx != null) {
                IOException ex = this.delayedEx;
                this.delayedEx = null;
                throw ex;
            }
        }
    }

    public static class Sink
    extends OutputStream {
        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(int b) {
        }
    }
}

