/*
 * Decompiled with CFR 0.152.
 */
package fc.fp.syxaw.util;

import fc.fp.syxaw.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class Log {
    public static final int ASSERTFAILED = 0;
    public static final int FP_MISSING = 1;
    public static final int FATALERROR = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int INFO = 5;
    public static final int DEBUG = 6;
    public static final int TIME = 7;
    private static long firstTs = -1L;
    private static Map statLogs = Collections.synchronizedMap(new HashMap());
    private static Map debugObjs = Collections.synchronizedMap(new HashMap());
    private static Stack contexts = new Stack();
    private static long contextId = 0L;
    private static PrintStream lout = System.out;
    private static MessageSink mout = null;
    public static final int LEVEL = Integer.parseInt(System.getProperty("syxaw.loglevel", "1000"));
    public static final boolean QUICKSTACK = Boolean.valueOf(System.getProperty("syxaw.quicklog", "false"));
    public static final int SPLIT_LINES = Integer.parseInt(System.getProperty("syxaw.log.maxline", "2000000000"));
    private static Map resmap;
    private static final String[] levels;
    private static List monlist;
    private static Map monxlist;
    private static long MW_INFO;
    private static long MW_DETACH;
    private static String[] leaks;
    private static String[] msgs;
    private static int[] delta_ms;
    private static final StringWriter stackOut;
    private static final PrintWriter stackWr;

    private static synchronized String newContext(String id) {
        return (contexts.isEmpty() ? "" : (String)contexts.peek() + "/") + id + "." + contextId++;
    }

    public static void setMessageSink(MessageSink s) {
        mout = s;
    }

    public static void putDebugObj(Object scope, String id, long value) {
        Log.putDebugObj(scope, id, new Long(value));
    }

    public static void putDebugObj(Object scope, String id, Object value) {
        String key = id + "\u0000" + scope.hashCode();
        debugObjs.put(key, value);
    }

    public static long getDebugLong(Object scope, String id, boolean delete) {
        return (Long)Log.getDebugObj(scope, id, delete);
    }

    public static Object getDebugObj(Object scope, String id, boolean delete) {
        String key = id + "\u0000" + scope.hashCode();
        if (delete) {
            return debugObjs.remove(key);
        }
        return debugObjs.get(key);
    }

    public static synchronized void beginContext(String id) {
        contexts.push(Log.newContext(id));
    }

    public static synchronized void endContext() {
        contexts.pop();
    }

    public static void stat(String log, String key1, Object val1) {
        Log.stat(log, new String[]{key1}, new Object[]{val1});
    }

    public static void stat(String log, String key1, Object val1, String key2, Object val2) {
        Log.stat(log, new String[]{key1, key2}, new Object[]{val1, val2});
    }

    public static void stat(String log, String key1, Object val1, String key2, Object val2, String key3, Object val3) {
        Log.stat(log, new String[]{key1, key2, key3}, new Object[]{val1, val2, val3});
    }

    public static void stat(String log, String key1, Object val1, String key2, Object val2, String key3, Object val3, String key4, Object val4) {
        Log.stat(log, new String[]{key1, key2, key3, key4}, new Object[]{val1, val2, val3, val4});
    }

    public static void stat(String log, String key1, Object val1, String key2, Object val2, String key3, Object val3, String key4, Object val4, String key5, Object val5) {
        Log.stat(log, new String[]{key1, key2, key3, key4, key5}, new Object[]{val1, val2, val3, val4, val5});
    }

    public static Map getStat(String log) {
        return Log.getStat(log, 0);
    }

    public static Map getStat(String log, int age) {
        Vector v = (Vector)statLogs.get(log);
        if (v != null) {
            return (Map)v.elementAt(v.size() - (age + 1));
        }
        return null;
    }

    public static int getStatSize(String log) {
        Vector v = (Vector)statLogs.get(log);
        if (v != null) {
            return v.size();
        }
        return 0;
    }

    public static Object getStat(String log, String key) {
        Map m = Log.getStat(log);
        return m != null ? m.get(key) : null;
    }

    public static Object getStat(String log, String key, int age) {
        Map m = Log.getStat(log, age);
        return m != null ? m.get(key) : null;
    }

    protected static synchronized void stat(String log, String[] keys, Object[] vals) {
        Vector stats = (Vector)statLogs.get(log);
        if (stats == null) {
            stats = new Vector();
            statLogs.put(log, stats);
        }
        HashMap<String, Object> valmap = new HashMap<String, Object>();
        valmap.put("_ts", new Long(System.currentTimeMillis()));
        if (!contexts.isEmpty()) {
            valmap.put("_cx", contexts.peek());
        }
        for (int i = 0; i < keys.length; ++i) {
            valmap.put(keys[i], vals[i]);
        }
        stats.add(valmap);
        Log.log("Stat to " + log + ": " + valmap, 5);
    }

    public static void allocres(Object key, String text) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(os);
            pw.println("MSG: " + text);
            new Exception().printStackTrace(pw);
            pw.flush();
            os.close();
            resmap.put(key, new String(os.toByteArray()));
        }
        catch (IOException x) {
            Log.log("", 2, x);
        }
    }

    public static void freeres(Object key) {
        resmap.remove(key);
    }

    public static void dumpres() {
        System.err.println("-------ALLOC RES DUMP -------");
        for (Map.Entry e : resmap.entrySet()) {
            System.err.println(e.getValue());
        }
    }

    protected Log() {
    }

    public static void log(String msg, int level) {
        Log.log(msg, level, null, 2);
    }

    public static void log(String msg, int level, Object o) {
        Log.log(msg, level, o, 2);
    }

    public static void time(String msg) {
        Log.log("" + System.currentTimeMillis() + ": " + msg, 7, null, 2);
    }

    public static void log(String msg, int level, Object o, int stpos) {
        if (level > LEVEL) {
            return;
        }
        if (firstTs == -1L) {
            firstTs = System.currentTimeMillis();
            Log.log("Time zero ", 5, new Date(firstTs));
        }
        String srcClass = "[not shown]";
        String srcMethod = "";
        String location = srcClass + "." + srcMethod;
        if (!QUICKSTACK || level <= 4) {
            srcClass = "<unknown class>";
            srcMethod = "<unknown method>";
            location = srcClass + "." + srcMethod;
        }
        long ts = (System.currentTimeMillis() - firstTs) / 10L;
        String cmsg = Util.format(String.valueOf(ts / 100L), -4) + "." + Util.format(String.valueOf(ts % 100L), 2, '0') + " " + levels[level] + " " + msg + (o == null ? "" : " " + o.toString());
        if (mout != null) {
            lout.println(cmsg);
            mout.message(cmsg);
        } else {
            while (cmsg.length() > SPLIT_LINES) {
                int chomppos = cmsg.indexOf(10) + 1;
                if (chomppos > SPLIT_LINES || chomppos < 1) {
                    chomppos = SPLIT_LINES;
                }
                lout.println(cmsg.substring(0, chomppos));
                cmsg = cmsg.substring(chomppos);
            }
            lout.println(cmsg);
            lout.flush();
        }
        if (level <= 2) {
            new Throwable().printStackTrace(System.err);
            Log.dumpres();
            System.gc();
            System.exit(-1);
        }
    }

    public static final Object memwatch(Object o) {
        monlist.add(o);
        monxlist.put(new LongHolder(MW_INFO | (long)(monlist.size() - 1)), Log.getLoc(1, 5));
        return o;
    }

    public static final Object memwatch(Object o, String msg, Object detacher) {
        monlist.add(o);
        long ix = monlist.size() - 1;
        monxlist.put(new LongHolder(MW_INFO | ix), msg == null ? Log.getLoc(1, 2) : msg);
        if (detacher != null) {
            monxlist.put(new LongHolder(MW_DETACH | ix), detacher);
        }
        return o;
    }

    public static final void memstat(PrintStream pw, String className, String keyword) {
        int i;
        Class[] MW_DT_ARGS = new Class[]{Object.class};
        Object[] dargs = new Object[1];
        long nid = 1000000L;
        ListIterator<WeakReference<Object>> li = monlist.listIterator();
        String msg = null;
        Object detacher = null;
        Object obj = null;
        Class<?> lastObj = null;
        LongHolder msgK = new LongHolder(-1L);
        LongHolder detachK = new LongHolder(-1L);
        int ix = -1;
        long topstart = -1L;
        long end = -1L;
        long freecount = 0L;
        long leaked = 0L;
        long prevleaked = 0L;
        long detaches = 0L;
        boolean match = false;
        boolean fwd = true;
        if ("##MWRIP##".equals(className)) {
            Log.log("Memwatcher resource RIP", 5);
            leaks = null;
            msgs = null;
            delta_ms = null;
            monlist.clear();
            li = monlist.listIterator();
            monxlist.clear();
        }
        try {
            int k;
            long start = Long.MAX_VALUE;
            for (k = 0; k < 10; ++k) {
                start = Math.min(start, Log.gcloop());
                Thread.sleep(1000L);
            }
            topstart = start;
            end = start;
            while (true) {
                if (fwd ? !li.hasNext() : !li.hasPrevious()) {
                    if (leaked == prevleaked || monlist.size() == 0) break;
                    prevleaked = leaked;
                    leaked = 0L;
                    fwd = !fwd;
                    continue;
                }
                ix = fwd ? li.nextIndex() : li.previousIndex();
                obj = fwd ? li.next() : li.previous();
                if (obj instanceof WeakReference) {
                    obj = ((WeakReference)obj).get();
                }
                if (obj == null) continue;
                msgK.set(MW_INFO + (long)ix);
                detachK.set(MW_DETACH + (long)ix);
                msg = (String)monxlist.get(msgK);
                detacher = monxlist.get(detachK);
                boolean bl = match = (className == null || obj.getClass().getName().indexOf(className) != -1) && (keyword == null || msg != null && msg.indexOf(keyword) != -1);
                if (!match) continue;
                lastObj = obj.getClass();
                li.set(null);
                if (detacher != null) {
                    dargs[0] = obj;
                    detacher.getClass().getMethod("_mw_detach", MW_DT_ARGS).invoke(detacher, dargs);
                    dargs[0] = null;
                    ++detaches;
                }
                WeakReference<Object> or = new WeakReference<Object>(obj);
                obj = null;
                end = Log.gcloop();
                if (or.get() == null) {
                    if (freecount < (long)msgs.length) {
                        Log.msgs[(int)freecount] = msg;
                        Log.delta_ms[(int)freecount] = (int)(start - end);
                    }
                    ++freecount;
                } else {
                    li.set(or);
                    if (leaked < (long)leaks.length) {
                        Log.leaks[(int)leaked] = msg;
                    }
                    ++leaked;
                }
                or = null;
                start = end;
            }
            for (k = 0; k < 5; ++k) {
                end = Math.min(start, Log.gcloop());
                Thread.sleep(250L);
            }
        }
        catch (Exception ex) {
            Log.log("Excepted (most likely on detach)", 5, ex);
            pw.println("Excepted (most likely on detach).");
        }
        if (msgs == null) {
            pw.println("Memory Watcher has been GCd!");
        }
        String line = "No objects freed. (freeMem=" + (topstart - end) + ", used=" + end + ")";
        if (lastObj != null) {
            line = lastObj.getName() + ", freeMem=" + (topstart - end) + ", count=" + freecount + ", detached=" + detaches + ", leaked=" + leaked + ", used=" + end;
        }
        pw.println(line);
        for (i = 0; msgs != null && (long)i < freecount && i < msgs.length; ++i) {
            if (msgs[i] == null) continue;
            pw.println(Util.format("M" + i, -5, ' ') + " " + Util.format("" + delta_ms[i], -6, ' ') + ": " + msgs[i]);
        }
        for (i = 0; leaks != null && (long)i < leaked && i < leaks.length; ++i) {
            if (leaks[i] == null) continue;
            pw.println(Util.format("L" + i, -5, ' ') + ": " + leaks[i]);
        }
    }

    private static final long gcloop() {
        System.runFinalization();
        Thread.yield();
        long usedmem = Log.usedMemory();
        while (true) {
            System.gc();
            Thread.yield();
            long usedmem2 = Log.usedMemory();
            if (usedmem2 == usedmem) {
                return usedmem;
            }
            usedmem = usedmem2;
        }
    }

    public static final long usedMemory(String loc) {
        long mem = Long.MAX_VALUE;
        try {
            for (int k = 0; k < 1; ++k) {
                mem = Math.min(mem, Log.gcloop());
                if (k <= 0) continue;
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Log.log("Used memory: " + Util.format("" + mem, -9, ' ') + " " + loc, 3);
        return mem;
    }

    private static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static final String getLoc(int offset, int maxdepth) {
        offset += 0;
        maxdepth += 2;
        String lastStep = "";
        String steps = "";
        stackOut.getBuffer().setLength(0);
        new Throwable().printStackTrace(stackWr);
        stackWr.flush();
        int depth = -1;
        StringBuffer buf = stackOut.getBuffer();
        int wordStart = -1;
        for (int pos = 0; pos < buf.length() && depth < maxdepth; ++pos) {
            char c = buf.charAt(pos);
            boolean atlb = c == '\n' | pos == buf.length() - 1;
            if (atlb) {
                ++depth;
                wordStart = -1;
            }
            if (Character.isWhitespace(c)) {
                wordStart = -1;
                continue;
            }
            if (wordStart < 0 && !Character.isWhitespace(c)) {
                wordStart = pos;
                continue;
            }
            if (c != '(' || depth <= offset) continue;
            String step = buf.substring(wordStart, pos);
            steps = steps + (lastStep.length() > 0 ? "," : "") + Log.rpath(lastStep, step);
            lastStep = step;
        }
        return steps;
    }

    public static final String rpath(String p1, String p2) {
        int match;
        for (match = 0; match < Math.min(p1.length(), p2.length()) && p1.charAt(match) == p2.charAt(match); ++match) {
        }
        String res = match - 1 > 0 ? "#" + p2.substring(match) : p2;
        return res;
    }

    public static final void setOut(PrintStream out) {
        lout = out;
    }

    public static void main(String[] args) {
        System.out.println(Log.getLoc(0, 100));
        Log.foo();
    }

    public static void foo() {
        System.out.println(Log.getLoc(0, 100));
        Log.bar();
    }

    public static void bar() {
        System.out.println(Log.getLoc(0, 0));
    }

    static {
        if (System.getProperty("syxaw.log.file", null) != null) {
            File f = new File(System.getProperty("syxaw.log.file", null));
            try {
                lout = new PrintStream(new FileOutputStream(f));
                System.setErr(lout);
                System.setOut(lout);
            }
            catch (FileNotFoundException ex) {
                System.err.println("Log init: WARNING: Cannot open " + f);
            }
        }
        if (System.getProperty("syxaw.logfilter", null) != null) {
            System.err.println("Log init: WARNING: FP edition has no filters");
        }
        resmap = new HashMap();
        levels = new String[]{"ASSERT FAIL", "FP:MISSING", "FATAL ERROR", "E", "W", "I", "D", "T"};
        monlist = new LinkedList();
        monxlist = new HashMap();
        MW_INFO = 0x100000000L;
        MW_DETACH = 0x200000000L;
        leaks = new String[64];
        msgs = new String[64];
        delta_ms = new int[msgs.length];
        stackOut = new StringWriter(1024);
        stackWr = new PrintWriter(stackOut);
    }

    private static class LongHolder {
        long l;

        public LongHolder(long l) {
            this.l = l;
        }

        public int hashCode() {
            return (int)(this.l ^ this.l >>> 32);
        }

        public void set(long l) {
            this.l = l;
        }

        public boolean equals(Object o) {
            return o instanceof LongHolder && ((LongHolder)o).l == this.l;
        }
    }

    public static interface MessageSink {
        public void message(String var1);
    }
}

