/*
 * Decompiled with CFR 0.152.
 */
package faxma.io;

import faxma.CanonicalEventSequence;
import faxma.HashAlgorithm;
import faxma.ImmutableArrayList;
import faxma.Preamble;
import faxma.XmlUtil;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.EventStream;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.XmlWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventUtil {
    private static HashAlgorithm<Event> EVENT_HA = new EventHasher();

    private EventUtil() {
    }

    public static <F extends EventSequence> EventSequence getEventSequence(TypedXmlParser pa, Class<F> model) throws IOException, IllegalArgumentException {
        EventStream es = null;
        if (model != null) {
            try {
                es = (EventSequence)model.getConstructor(EventSequence.class).newInstance(new EventStream(pa));
            }
            catch (SecurityException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            es = new EventStream(pa);
        }
        return es;
    }

    public static List<Event> makeEventList(EventSequence es, EventList preamble, List<Integer> posList, TypedXmlParser pa) throws IOException, IllegalArgumentException {
        if (es instanceof Preamble && preamble != null) {
            preamble.addAll(((Preamble)es).getPreamble());
        }
        int last = 0;
        int contentsInRow = 0;
        while ((posList == null || posList.add((pa.getLineNumber() << 16) + pa.getColumnNumber())) && es.get(last) != null) {
            if (es.get(last).getType() == 5 && es.get(last + 1) != null && es.get(last + 1).getType() == 5) {
                ++contentsInRow;
            }
            ++last;
        }
        int esSize = last;
        Event[] array = new Event[esSize - contentsInRow];
        EventUtil.canonicalizeForDiff(es, esSize, array);
        assert (array[array.length - 1] != null);
        return new ImmutableArrayList<Event>(array);
    }

    private static void canonicalizeForDiff(EventSequence es, int esSize, Event[] array) throws IllegalStateException {
        StringBuilder sb = new StringBuilder();
        NsPrefixComparator nsPrefixOrder = new NsPrefixComparator();
        AttributeComparator attributeOrder = new AttributeComparator();
        int state = 0;
        int lastDst = -1;
        int lastSrc = -1;
        int dest = 0;
        int i = 0;
        while (i <= esSize) {
            int lastState = state;
            int oldDst = dest;
            Event e = es.get(i);
            switch (state) {
                case 0: {
                    if (e == null) break;
                    array[dest++] = e;
                    break;
                }
                case 1: {
                    if (e == null || e.getType() != 7) {
                        Arrays.sort(array, lastDst, dest, nsPrefixOrder);
                    }
                    if (e == null) break;
                    array[dest++] = e;
                    break;
                }
                case 2: {
                    if (e == null || e.getType() != 3 && e.getType() != 12) {
                        Arrays.sort(array, lastDst, dest, attributeOrder);
                    }
                    if (e == null) break;
                    array[dest++] = e;
                    break;
                }
                case 3: {
                    if (e != null && e.getType() == 5) break;
                    int j = lastSrc;
                    while (j < i) {
                        sb.append((String)es.get(j).getValue());
                        ++j;
                    }
                    array[dest - 1] = Event.createContent((String)sb.toString());
                    sb.setLength(0);
                    if (e == null) break;
                    array[dest++] = e;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (lastState != (state = e == null ? 0 : (e.getType() == 7 ? 1 : (e.getType() == 3 || e.getType() == 12 ? 2 : (e.getType() == 5 ? 3 : 0))))) {
                lastDst = oldDst;
                lastSrc = i;
            }
            ++i;
        }
    }

    public static List<Event> getEventSequence(String f, EventList preamble) throws IOException {
        FileInputStream in = new FileInputStream(f);
        TypedXmlParser pa = XmlUtil.getXmlParser(in);
        return EventUtil.makeEventList(EventUtil.getEventSequence(pa, CanonicalEventSequence.class), preamble, null, pa);
    }

    public static HashAlgorithm<Event> getEventHashAlgorithm() {
        return EVENT_HA;
    }

    public static final void emit(Event e, XmlWriter wr, EventList el) throws IOException {
        assert (wr == null || el == null);
        if (wr != null) {
            wr.addEvent(e);
        } else {
            el.add(e);
        }
    }

    public static final void emit(Event e, EventList el, XmlWriter wr) throws IOException {
        assert (wr == null || el == null);
        if (el != null) {
            el.add(e);
        } else {
            wr.addEvent(e);
        }
    }

    public static final void emit(EventSequence es, XmlWriter wr, EventList el) throws IOException {
        assert (wr == null || el == null);
        if (wr != null) {
            wr.addEvents(es);
        } else {
            el.addAll(es);
        }
    }

    public static final void emit(EventSequence es, EventList el, XmlWriter wr) throws IOException {
        assert (wr == null || el == null);
        if (el != null) {
            el.addAll(es);
        } else {
            wr.addEvents(es);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributeComparator
    implements Comparator<Event> {
        AttributeComparator() {
        }

        @Override
        public int compare(Event e1, Event e2) {
            int r = e1.getName().compareTo(e2.getName());
            if (r == 0) {
                r = e1.getNamespace().compareTo(e2.getNamespace());
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NsPrefixComparator
    implements Comparator<Event> {
        NsPrefixComparator() {
        }

        @Override
        public int compare(Event e1, Event e2) {
            return ((String)e1.getValue()).compareTo((String)e2.getValue());
        }
    }

    public static class TestCanonicalizer {
        public static void main(String[] args) {
            EventList el = new EventList();
            el.add(Event.createStartDocument());
            el.add(Event.createNamespacePrefix((String)"http//zzz.example.com", (String)"z"));
            el.add(Event.createNamespacePrefix((String)"http//www.example.com", (String)"a"));
            el.add(Event.createStartElement((String)"", (String)"root"));
            el.add(Event.createStartElement((String)"", (String)"bar"));
            el.add(Event.createAttribute((String)"", (String)"zattr", (String)"zval"));
            el.add(Event.createAttribute((String)"", (String)"aattr", (String)"aval"));
            el.add(Event.createContent((String)"Hello"));
            el.add(Event.createEndElement((String)"", (String)"bar"));
            el.add(Event.createContent((String)"Hello"));
            el.add(Event.createContent((String)" World"));
            el.add(Event.createNamespacePrefix((String)"http//aaa.example.com", (String)"z"));
            el.add(Event.createStartElement((String)"", (String)"foo"));
            el.add(Event.createAttribute((String)"", (String)"aattr", (String)"aval"));
            el.add(Event.createStartElement((String)"", (String)"foo"));
            el.add(Event.createStartElement((String)"", (String)"root"));
            el.add(Event.createEndDocument());
            EventList ef = new EventList();
            ef.add(Event.createStartDocument());
            ef.add(Event.createNamespacePrefix((String)"http//www.example.com", (String)"a"));
            ef.add(Event.createNamespacePrefix((String)"http//zzz.example.com", (String)"z"));
            ef.add(Event.createStartElement((String)"", (String)"root"));
            ef.add(Event.createStartElement((String)"", (String)"bar"));
            ef.add(Event.createAttribute((String)"", (String)"aattr", (String)"aval"));
            ef.add(Event.createAttribute((String)"", (String)"zattr", (String)"zval"));
            ef.add(Event.createContent((String)"Hello"));
            ef.add(Event.createEndElement((String)"", (String)"bar"));
            ef.add(Event.createContent((String)"Hello World"));
            ef.add(Event.createNamespacePrefix((String)"http//aaa.example.com", (String)"z"));
            ef.add(Event.createStartElement((String)"", (String)"foo"));
            ef.add(Event.createAttribute((String)"", (String)"aattr", (String)"aval"));
            ef.add(Event.createStartElement((String)"", (String)"foo"));
            ef.add(Event.createStartElement((String)"", (String)"root"));
            ef.add(Event.createEndDocument());
            Object[] elc = new Event[ef.size()];
            EventUtil.canonicalizeForDiff((EventSequence)el, el.size(), (Event[])elc);
            int i = 0;
            while (i < elc.length) {
                if (!ef.get(i).equals((Object)elc[i])) {
                    throw new Error("Bad result at pos " + i + "; expected " + ef.get(i) + ", got " + elc[i]);
                }
                ++i;
            }
            System.out.println("FYI: The canonical array=\n" + Arrays.toString(elc));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EventHasher
    implements HashAlgorithm<Event> {
        private static final byte[] NONULL = new byte[1];

        EventHasher() {
        }

        @Override
        public short quickHash(Event o) {
            int hc = o.hashCode();
            return (short)(hc & 0xFFFF ^ hc >> 16);
        }

        @Override
        public void secureDigest(List<Event> el, MessageDigest md) {
            for (Event e : el) {
                md.update(new byte[]{(byte)e.getType(), (byte)(e.getType() >> 8), (byte)(e.getType() >> 16), (byte)(e.getType() >> 24)});
                if (e.getNamespace() != null) {
                    md.update(NONULL);
                    md.update(e.getNamespace().getBytes());
                }
                if (e.getName() != null) {
                    md.update(NONULL);
                    md.update(e.getName().getBytes());
                }
                if (e.getValue() == null) continue;
                md.update(NONULL);
                md.update(e.getValue().toString().getBytes());
            }
        }
    }
}

