/*
 * Decompiled with CFR 0.152.
 */
package faxma;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableArrayList<E>
implements List<E> {
    private E[] array;
    int base;
    int len;

    public ImmutableArrayList(E[] array) {
        this(array, 0, array.length);
    }

    public ImmutableArrayList(E[] array, int base, int end) {
        this.array = array;
        this.base = base;
        this.len = end - base;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new IALIterator(this.base, this.base + this.len);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < this.len) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.array[i + this.base].toString());
            ++i;
        }
        return sb.append(']').toString();
    }

    @Override
    public E[] toArray() {
        return this.array;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        assert (index < this.len && index > -1);
        return this.array[this.base + index];
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new IALIterator(this.base, this.base + this.len);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        assert (index < this.len);
        return new IALIterator(this.base + index, this.base + this.len);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        assert (toIndex <= this.len && fromIndex <= toIndex && toIndex > -1);
        return new ImmutableArrayList<E>(this.array, this.base + fromIndex, this.base + toIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IALIterator
    implements ListIterator<E> {
        int min;
        int max;
        int i;

        public IALIterator(int min, int max) {
            this.min = min;
            this.max = max;
            this.i = min;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.max;
        }

        @Override
        public E next() {
            return ImmutableArrayList.this.array[this.i++];
        }

        @Override
        public boolean hasPrevious() {
            return this.i > this.min;
        }

        @Override
        public E previous() {
            return ImmutableArrayList.this.array[--this.i];
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }
    }
}

