/*
 * Decompiled with CFR 0.152.
 */
package faxma;

import faxma.Preamble;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.TransformedEventStream;
import fc.fp.util.xas.XmlReader;
import java.util.Enumeration;

public class CanonicalEventSequence
extends TransformedEventStream
implements Preamble {
    protected boolean normalizeWhitespace = true;
    protected boolean stripDocumentStartEnd = false;
    protected EventList preamble = null;
    protected StringBuilder currentString = new StringBuilder();

    public CanonicalEventSequence(EventSequence in) {
        super(in);
        this.preamble = new EventList();
        Enumeration en = in.events();
        while (en.hasMoreElements()) {
            Event e = (Event)en.nextElement();
            if (e.getType() == 2) break;
            if (e.getType() == 0) continue;
            this.preamble.add(e);
        }
    }

    public CanonicalEventSequence(EventSequence in, boolean normalizeWhitespace, boolean stripDocumentStartEnd) {
        this(in);
        this.normalizeWhitespace = normalizeWhitespace;
        this.stripDocumentStartEnd = stripDocumentStartEnd;
    }

    public EventSequence getPreamble() {
        return this.preamble;
    }

    protected void transform(Event ev, EventList el, XmlReader xr) {
        if (ev.getType() == 8) {
            return;
        }
        if (ev.getType() == 5 && this.normalizeWhitespace && this.isWhiteSpace((String)ev.getValue())) {
            return;
        }
        if (ev.getType() == 5) {
            this.currentString.append((String)ev.getValue());
            return;
        }
        if (ev.getType() == 9) {
            return;
        }
        if (ev.getType() == 7) {
            return;
        }
        if ((ev.getType() == 0 || ev.getType() == 1) && this.stripDocumentStartEnd) {
            assert (this.currentString.length() == 0);
            return;
        }
        if (this.currentString.length() > 0) {
            el.add(Event.createContent((String)CanonicalEventSequence.canonicalize(this.currentString)));
            this.currentString.setLength(0);
        }
        el.add(ev);
    }

    protected static final String canonicalize(StringBuilder sb) {
        if (sb.length() == 0) {
            return "";
        }
        boolean stateWS = CanonicalEventSequence.isWhiteSpace(sb.charAt(0));
        int dst = 0;
        int src = 0;
        while (src < sb.length()) {
            char ch = sb.charAt(src);
            if (stateWS) {
                stateWS = CanonicalEventSequence.isWhiteSpace(ch);
                if (!stateWS) {
                    sb.setCharAt(dst++, ch);
                }
            } else {
                stateWS = CanonicalEventSequence.isWhiteSpace(ch);
                sb.setCharAt(dst++, stateWS ? (char)' ' : (char)ch);
            }
            ++src;
        }
        return sb.substring(0, dst - (stateWS ? 1 : 0));
    }

    protected final boolean isWhiteSpace(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        int pos = 0;
        while (pos < len) {
            if (!CanonicalEventSequence.isWhiteSpace(s.charAt(pos))) {
                return false;
            }
            ++pos;
        }
        return true;
    }

    protected static final boolean isWhiteSpace(char ch) {
        return ch <= ' ' || Character.isWhitespace(ch);
    }
}

