/*
** FILE:   xv_XmlStyleContext.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    18Jul98  stevew  Created.
*/
package xv;

//import xm.xm_DocumentModel;

//import xg.xg_Node;

import eh.eh_Debug;

import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;

import java.util.Vector;

//*****************************************************************************
/** A collection of styles used to render an XML source.
 */
public class xv_XmlStyleContext extends StyleContext
{
    /** The styles representing the actual token types. */
    Style[]   tokenStyles;

    /** Cache of foreground colors to represent the various tokens. */
    transient Color[] tokenColors;

    /** Cache of fonts to represent the various tokens. */
    transient Font[]  tokenFonts;

    //*****************************************************************************
    /** Default constructor. Construct a set of styles to represent XML lexical
     *  tokens. By default there are no colours or fonts specified.
     */
    public xv_XmlStyleContext()
    {
//	    super();
        eh_Debug.add(6, "Construct xv_XmlStyleContext");
/*    	Style root = getStyle(DEFAULT_STYLE);
    	tokenStyles = new Style[Token.MaximumScanValue + 1];
    	Token[] tokens = Token.all;
    	int n = tokens.length;
    	for (int i = 0; i < n; i++)
        {
	        Token t = tokens[i];
    	    Style parent = getStyle(t.getCategory());
    	    if (parent == null)
            {
        		parent = addStyle(t.getCategory(), root);
    	    }
	        Style s = addStyle(null, parent);
    	    s.addAttribute(Token.TokenAttribute, t);
    	    tokenStyles[t.getScanValue()] = s;
    	}
*/
    }

    //*****************************************************************************
    /** Get the foreground colour to use for a lexical token with the given value.
     *
     *  @param  attr  attribute set from a token element that has a Token in the set.
     */
    public Color getForeground(int code)
    {
        eh_Debug.add(6, "xv_XmlStyleContext.getForeground");
/*	    if (tokenColors == null)
        {
    	    tokenColors = new Color[Token.MaximumScanValue + 1];
    	}
    	if ((code >= 0) && (code < tokenColors.length))
        {
    	    Color c = tokenColors[code];
    	    if (c == null)
            {
        		Style s = tokenStyles[code];
        		c = StyleConstants.getForeground(s);
    	    }
    	    return c;
    	}
*/
    	return Color.red;
//    	return Color.black;
    }

    //*****************************************************************************
    /** Get the font to use for a lexical token with the given scan value.
     */
    public Font getFont(int code)
    {
        eh_Debug.add(6, "xv_XmlStyleContext.getFont");
/*    	if (tokenFonts == null)
        {
            tokenFonts = new Font[Token.MaximumScanValue + 1];
    	}
    	if (code < tokenFonts.length)
        {
    	    Font f = tokenFonts[code];
    	    if (f == null)
            {
        		Style s = tokenStyles[code];
        		f = getFont(s);
    	    }
    	    return f;
    	}
*/        
    	return null;
    }

    //*****************************************************************************
    /** Get the attribute set to use for the given scan code. The set is stored in
     *  a table to facilitate relatively fast access to use in conjunction with the
     *  scanner.
     */
    public Style getStyleForScanValue(int code)
    {
        eh_Debug.add(6, "xv_XmlStyleContext.getStyleForScanValue");
    	if (code < tokenStyles.length)
        {
    	    return tokenStyles[code];
	    }
    	return null;
    }
}

//*****************************************************************************

