/*
** FILE:   xv_XmlEditorKit.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    18Jul98  stevew  Created.
*/
package xv;

import xm.xm_DocumentModel;

import eh.eh_Debug;

//import com.sun.java.swing.text.DefaultEditorKit;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.StyledEditorKit;
import com.sun.java.swing.text.ViewFactory;

//*****************************************************************************
/** A Swing text editor kit to support the editing of XML. This kit supports a
 *  fairly minimal handling of editing java text content. It supports syntax
 *  highlighting and produces the lexical structure of the document as best it
 *  can.
 */
public class xv_XmlEditorKit extends StyledEditorKit
{
    /** The XML style context. */
    xv_XmlStyleContext  TheXmlStyleContext;

    /** The factory for creating Views. */
    xv_ViewFactory      TheViewFactory = new xv_ViewFactory();

    //*****************************************************************************
    /** Default constructor.
      */
    public xv_XmlEditorKit()
    {
//	    super();
        eh_Debug.add(6, "Construct xv_XmlEditorKit");
    }

    //*****************************************************************************
    /** Set the XML style context.
     *
     *  @param  InputXmlStyleContext  The style context
     */
    public void setStylePreferences(xv_XmlStyleContext InputXmlStyleContext)
    {
	    TheXmlStyleContext = InputXmlStyleContext;
    }

    //*****************************************************************************
    /** Retrieve the XML style context.
     *
     *  @return  The style context
     */
    public xv_XmlStyleContext getStylePreferences()
    {
	    if (TheXmlStyleContext == null)
	        TheXmlStyleContext = new xv_XmlStyleContext();
	    return TheXmlStyleContext;
    }

    //*****************************************************************************
    //*EditorKit*methods***********************************************************
    //*****************************************************************************
    /** Get the MIME type of the data that this kit represents support for. This
     *  kit supports the type <code>text/xml</code>.
     */
    public String getContentType()
    {
        eh_Debug.add(6, "xv_XmlEditorKit.getContentType: return 'text/xml'");
	    return "text/xml";
    }

    //*****************************************************************************
    /** Create a copy of the editor kit. This allows an implementation to serve as
     *  a prototype for others, so that they can be quickly created.
     */
    public Object clone()
    {
        eh_Debug.add(6, "xv_XmlEditorKit.clone");
	    xv_XmlEditorKit  NewEditorKit = new xv_XmlEditorKit();
    	NewEditorKit.TheXmlStyleContext = TheXmlStyleContext;
    	return NewEditorKit;
    }

    //*****************************************************************************
    /** Create an uninitialized text storage model appropriate for this type of
     *  editor.
     *
     *  @return  the model
     */
    public Document createDefaultDocument()
    {
        eh_Debug.add(6, "xv_XmlEditorKit.createDefaultDocument");
	    return(new xm_DocumentModel(null) );
    }

    //*****************************************************************************
    /** Return the factory for producing views of any models that are produced by
     *  this kit.
     *
     *  @return  The view factory
     */
    public final ViewFactory getViewFactory()
    {
        eh_Debug.add(6, "xv_XmlEditorKit.getViewFactory");
	    return TheViewFactory;
    }
}

//*****************************************************************************
