/*
 * @(#)Utilities.java	1.5 98/03/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package xv;

import java.awt.*;
import java.util.*;
import java.io.*;
import java.net.*;

import com.sun.java.swing.*;

/*
 * A class of general purpose HTML utilities
 *
 * @author  Jill Nakata
 * @version 1.5 03/13/98
 */

class xv_HtmlUtilities {

    /**
     * Converts a type Color to a hex string 
     * in the format "#RRGGBB"
     */
    static public String colorToHex(Color color) {

      String colorstr = new String("#");

      // Red
      String str = Integer.toHexString(color.getRed());
      if (str.length() > 2)
	throw new Error("invalid red value");
      else if (str.length() < 2)
	colorstr += "0" + str;
      else
	colorstr += str;
      
      // Green
      str = Integer.toHexString(color.getGreen());
      if (str.length() > 2)
	throw new Error("invalid green value");
      else if (str.length() < 2)
	colorstr += "0" + str;
      else
	colorstr += str;
      
      // Blue
      str = Integer.toHexString(color.getBlue());
      if (str.length() > 2)
	throw new Error("invalid green value");
      else if (str.length() < 2)
	colorstr += "0" + str;
      else
	colorstr += str;

      return colorstr;
    }

    /**
     * Determine if an end </TAG> is needed 
     * for the given tag.
     */
    static public boolean endTagNeeded(String tag) {

        // These should not have an end </TAGNAME>.
	if (tag.equals(xv_HtmlConstants.BASE) ||
	    tag.equals(xv_HtmlConstants.ISINDEX) ||
	    tag.equals(xv_HtmlConstants.LINK) ||
	    tag.equals(xv_HtmlConstants.META))
	  return false;

        // These require </TAGNAME>.
        else if (tag.equals(xv_HtmlConstants.BODY) ||
		 tag.equals(xv_HtmlConstants.HEAD) ||
		 tag.equals(xv_HtmlConstants.SCRIPT) ||
		 tag.equals(xv_HtmlConstants.STYLE) ||
		 tag.equals(xv_HtmlConstants.TITLE) ||
      		 tag.equals(xv_HtmlConstants.P) ||
      		 tag.equals(xv_HtmlConstants.PRE) ||
      		 tag.equals(xv_HtmlConstants.CODE) ||
      		 tag.equals(xv_HtmlConstants.CENTER) ||
      		 tag.equals(xv_HtmlConstants.DIV) ||
      		 tag.equals(xv_HtmlConstants.BLOCKQUOTE) ||
      		 tag.equals(xv_HtmlConstants.KBD) ||
      		 tag.equals(xv_HtmlConstants.B) ||
      		 tag.equals(xv_HtmlConstants.I) ||
      		 tag.equals(xv_HtmlConstants.U) ||
      		 tag.equals(xv_HtmlConstants.CITE) ||
      		 tag.equals(xv_HtmlConstants.BIG) ||
      		 tag.equals(xv_HtmlConstants.SMALL) ||
      		 tag.equals(xv_HtmlConstants.DFN) ||
      		 tag.equals(xv_HtmlConstants.EM) ||
      		 tag.equals(xv_HtmlConstants.SAMP) ||
      		 tag.equals(xv_HtmlConstants.STRIKE) ||
      		 tag.equals(xv_HtmlConstants.STRONG) ||
      		 tag.equals(xv_HtmlConstants.SUB) ||
      		 tag.equals(xv_HtmlConstants.SUP) ||
      		 tag.equals(xv_HtmlConstants.TT) ||
      		 tag.equals(xv_HtmlConstants.VAR))
	  return true;
        else
          return true;
    }

     /**
      * Convert a "#FFFFFF" hex string to a Color
      */
     public static final Color hexToColor(String value) {
	if (value.length() != 7) {
	  throw new Error("invalid hex color string length");
        }
	else if (value.startsWith("#")) {
	  String str = "0x" + value.substring(1, value.length());

	  Color c = Color.decode(value);
	  return c;
	}
	return null;
     }

     /**
      * Convert a 2 position hex number "NN" string into an integer
      */
     static final int stringToHex(String str) {
	if (str.length() != 2)
	  throw new Error("invalid hex string" + str);

	int pos1 = Character.digit(str.charAt(0), 16) * 16;
	int pos0 = Character.digit(str.charAt(1), 16);
	return(pos0 + pos1);
     }

     /**
      * Convert a color string "RED" or "#NNNNNN" to a Color.
      * Note: This will only convert the HTML3.2 colors strings
      *       or string of length 7
      *       otherwise, it will throw an HTMLException.
      */
    static public final Color stringToColor(String str) {
      Color color = null;

      if (str.charAt(0) == '#') 
        color = hexToColor(str);
      else if (str.equalsIgnoreCase("Black"))
        color = hexToColor("#000000");
      else if(str.equalsIgnoreCase("Silver"))
        color = hexToColor("#C0C0C0");
      else if(str.equalsIgnoreCase("Gray"))
        color = hexToColor("#808080");
      else if(str.equalsIgnoreCase("White"))
        color = hexToColor("#FFFFFF");
      else if(str.equalsIgnoreCase("Maroon"))
        color = hexToColor("#800000");
      else if(str.equalsIgnoreCase("Red"))
        color = hexToColor("#FF0000");
      else if(str.equalsIgnoreCase("Purple"))
        color = hexToColor("#800080");
      else if(str.equalsIgnoreCase("Fuchsia"))
        color = hexToColor("#FF00FF");
      else if(str.equalsIgnoreCase("Green"))
        color = hexToColor("#008000");
      else if(str.equalsIgnoreCase("Lime"))
        color = hexToColor("#00FF00");
      else if(str.equalsIgnoreCase("Olive"))
        color = hexToColor("#808000");
      else if(str.equalsIgnoreCase("Yellow"))
        color = hexToColor("#FFFF00");
      else if(str.equalsIgnoreCase("Navy"))
        color = hexToColor("#000080");
      else if(str.equalsIgnoreCase("Blue"))
        color = hexToColor("#0000FF");
      else if(str.equalsIgnoreCase("Teal"))
        color = hexToColor("#008080");
      else if(str.equalsIgnoreCase("Aqua"))
        color = hexToColor("#00FFFF");
      return color;
    }
 

   /**
    * Remove begin and end quotes and return string:
    * "xxxxx" returns xxxxx.
    */
   static public String removeSurroundingQuotes(String s) {
     String result = new String(s);
     if (s.startsWith("\"") && s.endsWith("\"")) {
       result = new String(s.substring(1, s.length()-1));
     }
     return result;
   }

    public static  ImageIcon  loadImage(Component c, String imageName){
        Toolkit toolkit = c.getToolkit();
	if(toolkit == null)
	  return null;
        URL url = null;
	try {
	  url = new URL(imageName);
	  InputStream is = (url.openConnection()).getInputStream();
	  is.close();
	}catch (MalformedURLException e){
	  File f = new File(imageName);
	  if(!f.canRead())
	    return null;
	}catch (IOException io){
	  return null;
	}
	
        Image image;
	if(url != null)
	  image = toolkit.getImage(url);
	else
	  image = toolkit.getImage(imageName);
	
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
	  tracker.waitForID(0);
        } catch (InterruptedException e) {
	  System.out.println(e);
	  return null;
        }
	
        ImageIcon ig = new ImageIcon(image);
	if (ig.getIconWidth() == -1 || ig.getIconHeight() == -1)
	  return null;
	else
	  return ig;
    }
}

