/*
 * @(#)Constants.java	1.3 98/04/12
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package xv;

/**
 * Constants used in the HTMLDocument.  These
 * are basically tag names and attribute definitions.
 * The definitions will be cleaned up and will become
 * public in the next release.
 *
 * @author  Timothy Prinzing
 * @version 1.3 04/12/98
 */
/*public*/ class xv_HtmlConstants {

    // --- Tags  -----------------------------------

    /**
     * PENDING(prinz) This is what the tag definitions
     * are about to become.  These can be used in a hashtable
     * efficiently.

    public static class Tag {
	
	Tag(String id) {
	    name = id;
	}

        public String toString() {
	    return name;
	}
            
	String name;
    }

    public static final Tag A = new Tag("a");
    public static final Tag ADDRESS = new Tag("address");
    public static final Tag APPLET = new Tag("applet");
    public static final Tag AREA = new Tag("area");
    public static final Tag B = new Tag("b");
    public static final Tag BASE = new Tag("base");
    public static final Tag BASEFONT = new Tag("basefont");
    public static final Tag BIG = new Tag("big");
    public static final Tag BLOCKQUOTE = new Tag("blockquote");
    public static final Tag BODY = new Tag("body");
    public static final Tag BR = new Tag("br");
    public static final Tag CAPTION = new Tag("caption");
    public static final Tag CENTER = new Tag("center");
    public static final Tag CITE = new Tag("cite");
    public static final Tag CODE = new Tag("code");
    public static final Tag COLOR = new Tag("color");
    public static final Tag DD = new Tag("dd");
    public static final Tag DFN = new Tag("dfn");
    public static final Tag DIR = new Tag("dir");
    public static final Tag DIV = new Tag("div");
    public static final Tag DL = new Tag("dl");
    public static final Tag DT = new Tag("dt");
    public static final Tag EM = new Tag("em");
    public static final Tag FACE = new Tag("face");
    public static final Tag FONT = new Tag("font");
    public static final Tag FORM = new Tag("form");
    public static final Tag H1 = new Tag("h1");
    public static final Tag H2 = new Tag("h2");
    public static final Tag H3 = new Tag("h3");
    public static final Tag H4 = new Tag("h4");
    public static final Tag H5 = new Tag("h5");
    public static final Tag H6 = new Tag("h6");
    public static final Tag HEAD = new Tag("head");
    public static final Tag HR = new Tag("hr");
    public static final Tag HTML = new Tag("html");
    public static final Tag I = new Tag("i");
    public static final Tag IMG = new Tag("img");
    public static final Tag INPUT = new Tag("input");
    public static final Tag ISINDEX = new Tag("isindex");
    public static final Tag KBD = new Tag("kbd");
    public static final Tag LI = new Tag("li");
    public static final Tag LINK = new Tag("link");
    public static final Tag MAP = new Tag("map");
    public static final Tag MENU = new Tag("menu");
    public static final Tag META = new Tag("meta");
    public static final Tag OL = new Tag("ol");
    public static final Tag OPTION = new Tag("option");
    public static final Tag P = new Tag("p");
    public static final Tag PARAM = new Tag("param");
    public static final Tag PRE = new Tag("pre");
    public static final Tag PROMPT = new Tag("prompt");
    public static final Tag SAMP = new Tag("samp");
    public static final Tag SCRIPT = new Tag("script");
    public static final Tag SELECT = new Tag("select");
    public static final Tag SMALL = new Tag("small");
    public static final Tag SRC = new Tag("src");
    public static final Tag STRIKE = new Tag("strike");
    public static final Tag STRONG = new Tag("strong");
    public static final Tag STYLE = new Tag("style");
    public static final Tag SUB = new Tag("sub");
    public static final Tag SUP = new Tag("sup");
    public static final Tag TABLE = new Tag("table");
    public static final Tag TD = new Tag("td");
    public static final Tag TEXT = new Tag("text");
    public static final Tag TEXTAREA = new Tag("textarea");
    public static final Tag TH = new Tag("th");
    public static final Tag TITLE = new Tag("title");
    public static final Tag TR = new Tag("tr");
    public static final Tag TT = new Tag("tt");
    public static final Tag U = new Tag("u");
    public static final Tag UL = new Tag("ul");
    public static final Tag VAR = new Tag("var");
    */
  
  static final String A = "a";
  static final String ADDRESS = "address";
  static final String APPLET = "applet";
  static final String AREA = "area";
  static final String B = "b";
  static final String BASE = "base";
  static final String BASEFONT = "basefont";
  static final String BIG = "big";
  static final String BLOCKQUOTE = "blockquote";
  static final String BODY = "body";
  static final String BR = "br";
  static final String CAPTION = "caption";
  static final String CENTER = "center";
  static final String CITE = "cite";
  static final String CODE = "code";
  static final String COLOR = "color";
  static final String DD = "dd";
  static final String DFN = "dfn";
  static final String DIR = "dir";
  static final String DIV = "div";
  static final String DL = "dl";
  static final String DT = "dt";
  static final String EM = "em";
  static final String FACE = "face";
  static final String FONT = "font";
  static final String FORM = "form";
  static final String H1 = "h1";
  static final String H2 = "h2";
  static final String H3 = "h3";
  static final String H4 = "h4";
  static final String H5 = "h5";
  static final String H6 = "h6";
  static final String HEAD = "head";
  static final String HR = "hr";
  static final String HTML = "html";
  static final String I = "i";
  static final String IMG = "img";
  static final String INPUT = "input";
  static final String ISINDEX = "isindex";
  static final String KBD = "kbd";
  static final String LI = "li";
  static final String LINK = "link";
  static final String MAP = "map";
  static final String MENU = "menu";
  static final String META = "meta";
  static final String OL = "ol";
  static final String OPTION = "option";
  static final String P = "p";
  static final String PARAM = "param";
  static final String PRE = "pre";
  static final String PRELINE = "pre-line";
  static final String PROMPT = "prompt";
  static final String SAMP = "samp";
  static final String SCRIPT = "script";
  static final String SELECT = "select";
  static final String SMALL = "small";
  static final String SRC = "src";
  static final String STRIKE = "strike";
  static final String STRONG = "strong";
  static final String STYLE = "style";
  static final String SUB = "sub";
  static final String SUP = "sup";
  static final String TABLE = "table";
  static final String TD = "td";
  static final String TEXT = "text";
  static final String TEXTAREA = "textarea";
  static final String TH = "th";
  static final String TITLE = "title";
  static final String TR = "tr";
  static final String TT = "tt";
  static final String U = "u";
  static final String UL = "ul";
  static final String VAR = "_var";

    // PENDING(prinz) The attribute keys should be immutable
    // objects for fast lookup/compare.  The following needs
    // to change before it can be public.  Also, some of these
    // should be deleted and the well known constant used.  
    // Others are not actually attributes.
    // THESE NEED TO BE CLEANED UP!

    // AttributeNames
    static final String ALIGN = "align";
    static final String LEFT = "left";
    static final String RIGHT = "right";
    static final String BOLD = "bold";
    static final String ITALIC = "italic";
    static final String UNDERLINE = "underline";
    static final String SIZE = "size";
    static final String PARAGRAPH = "paragraph";
    static final String HEIGHT = "height";
    static final String WIDTH = "width";
    static final String HREF = "href";
    static final String TYPE = "type";
    static final String COMPACT = "compact";
    static final String VALUE = "value";
    static final String NOSHADE= "noshade";
    static final String HSPACE = "hspace";
    static final String VSPACE = "vspace";
    static final String ALT = "alt";
    static final String BORDER = "border";
    static final String ISMAP = "ismap";
    static final String USEMAP = "usemap";
    static final String NAME = "name";
    static final String REL = "rel";
    static final String REV = "rev";
    static final String START = "start";
    static final String ROWS = "rows";
    static final String COLS = "cols";
    static final String NULL_ATTRIBUTE = "#DEFAULT";

    /**
     * The property name for the actual html tag name used
     * as an attribute for the writer.
     */
    static final String HTMLTagAttribute = "htmltag";

    /**
     * The property name for the base href which is used to
     * define the absolute URL against relatives URLs in the document.
     */
    static final String BaseHrefProperty = "basehref";

    /**
     * The property name for the BGCOLOR which is used to
     * define the Background Color for a HTML Document
     */
    static final String BGCOLOR = "bgcolor";

    /**
     * The property name for the BACKGROUND (Image) which is used to
     * define the Background Image for a HTML Document
     */
    static final String BACKGROUND = "background";

    /**
     * The property name for the Keywords  which is used to
     * define the keywords for a HTML Document
     */
    static final String KEYWORDS = "Keywords";

    /**
     * The property name for the VLINK  which is used to
     * define the visited hyperlink color for a HTML Document
     */
    static final String VLINK = "vlink";

    /**
     * The property name for the ALINK  which is used to
     * define the  active hyperlink color for a HTML Document
     */
    static final String ALINK = "alink";

    /**
     * The attribute name used to identify INPUT tag elements.
     */
    static final String HTMLInputComponent = "input-component";



  // Misc.
  static final String IMPLIEDP = "impliedp";


}
