/*
** FILE:   xv_ColouredSourceView.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    25Jul98  stevew  Created, based on Sun's example JavaView.
*/
package xv;

//import xm.xm_DocumentModel;

import xg.xg_Node;

import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import com.sun.java.swing.text.BadLocationException;
//import com.sun.java.swing.text.BoxView;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
//import com.sun.java.swing.text.LabelView;
//import com.sun.java.swing.text.ParagraphView;
//import com.sun.java.swing.text.PlainView;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.WrappedPlainView;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;

import java.util.Vector;

//*****************************************************************************
/** View for displaying an XML source with simple colour-coding of its different
 *  parts. A constant font family and size is used.
 */
class xv_ColouredSourceView extends WrappedPlainView
{
// 	JavaDocument.Scanner lexer;

   	boolean              lexerValid;
    //*****************************************************************************
  	/** Construct a simple colourized view of an XML source.
  	 */
   	xv_ColouredSourceView(Element InputElement)
    {
  	    super(InputElement);
        eh_Debug.add(6, "Construct xv_ColouredSourceView for element " + InputElement);
// 	    JavaDocument doc = (JavaDocument)getDocument();
// 	    lexer = doc.createScanner();
   	    lexerValid = false;
   	}

    //*****************************************************************************
    /** Render using the given rendering surface and area on that surface. This is
     *  implemented to invalidate the lexical scanner after rendering so that the
     *  next request to drawUnselectedText will set a new range for the scanner.
     *
     * @param g the rendering surface to use
     * @param a the allocated region to render into
     *
     * @see View#paint
     */
    public void paint(Graphics g, Shape a)
    {
        super.paint(g, a);
        eh_Debug.add(7, "xv_ColouredSourceView.paint");
    	lexerValid = false;
    }

    //*****************************************************************************
    /** Render the given range in the model as normal unselected text. This is
     *  implemented to paint colors based upon the token-to-colour translations.
     *  To reduce the number of calls to the Graphics object, text is batched up
     *  until a colour change is detected or the entire requested range has been
  	 * reached.
   	 *
   	 * @param g the graphics context
   	 * @param x the starting X coordinate
   	 * @param y the starting Y coordinate
   	 * @param p0 the beginning position in the model
   	 * @param p1 the ending position in the model
   	 * @returns the location of the end of the range
   	 * @exception BadLocationException if the range is invalid
   	 */
    protected int drawUnselectedText(Graphics g,
                                     int x,
                                     int y,
        		                     int p0,
                                     int p1) throws BadLocationException
    {
        eh_Debug.add(7, "xv_ColouredSourceView.drawUnselectedText: Positions " + p0 + "-" + p1);
        return super.drawUnselectedText(g,
                                        x,
                                        y,
	    		                        p0,
                                        p1);
/*    	    Document doc = getDocument();
    	    Color last = null;
    	    int mark = p0;
    	    for (; p0 < p1; )
            {
        		updateScanner(p0);
        		int p = Math.min(lexer.getEndOffset(), p1);
        		p = (p <= p0) ? p1 : p;
        		Color fg = getForeground(lexer.token);
        		if (fg != last && last != null)
                {
        		    // color change, flush what we have
        		    g.setColor(last);
        		    Segment text = getLineBuffer();
        		    doc.getText(mark, p0 - mark, text);
        		    x = Utilities.drawTabbedText(text, x, y, g, this, mark);
        		    mark = p0;
        		}
        		last = fg;
        		p0 = p;
    	    }
    	    // flush remaining
    	    g.setColor(last);
    	    Segment text = getLineBuffer();
    	    doc.getText(mark, p1 - mark, text);
    	    x = Utilities.drawTabbedText(text, x, y, g, this, mark);

    	    return x;
*/
   	}

    //*****************************************************************************
  	/** Update the scanner (if necessary) to point to the appropriate
   	 *  token for the given start position needed for rendering.
   	 */
/*    	protected void updateScanner(int p)
        {
            eh_Debug.add(6, "xv_ColouredSourceView.updateScanner");
    	    try
            {
        		if (! lexerValid)
                {
        		    JavaDocument doc = (JavaDocument) getDocument();
        		    lexer.setRange(doc.getScannerStart(p), doc.getLength());
        		    lexerValid = true;
        		}
        		while (lexer.getEndOffset() <= p)
                {
        		    lexer.scan();
        		}
    	    }
            catch (Throwable e)
            {
        		// can't adjust scanner... calling logic
        		// will simply render the remaining text.
        		e.printStackTrace();
   	    }
    }
*/
}

//*****************************************************************************

