//*****************************************************************************
/*
** FILE:   xu_ToolBarElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    07May98  stevew  Created.
*/
package xu;

import xg.xg_Element;
import xg.xg_Node;
import xg.xg_VerificationException;

import eh.eh_Debug;

import com.sun.java.swing.Box;
import com.sun.java.swing.JToolBar;

//*****************************************************************************
/** An XML element to represent a Swing toolbar.
*/
public class xu_ToolBarElement extends xg_Element
{
    /** The toolbar created by this element. */
    protected JToolBar         TheToolBar        = new JToolBar();

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName    = "ToolBar";

    /** The element type name used in XML for a toolbar separator. */
    public final static String SeparatorTypeName = "Separator";

    //*****************************************************************************
    /** Construct a toolbar element with no type and no name.
     */
    public xu_ToolBarElement()
    {
    }

    //*****************************************************************************
    /** Construct a toolbar with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xu_ToolBarElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if each of its children
     *  is an xu_ToolBarButtonElement, an xg_Element of type "Separator" or not an
     *  xg_Element.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "xu_ToolBarElement.verify: Verify '" + toString() + "'");

        // Check the children are the right sort, and add them if they are.
        xg_Node  CurrentChild = null;

        for (int CurrentChildIndex = 0;
             CurrentChildIndex < getChildCount();
             CurrentChildIndex++)
        {
            CurrentChild = (xg_Node)getChildAt(CurrentChildIndex);

            // Check this child is of an acceptable type.
            if (CurrentChild instanceof xg.xg_Element)
            {
                if (CurrentChild instanceof xu.xu_ToolBarButtonElement)
                    // Add the toolbar button in this element to the ToolBar.
                    TheToolBar.add(((xu.xu_ToolBarButtonElement)CurrentChild).getButton());
                else if (CurrentChild.getName().equals(SeparatorTypeName) )
        		    TheToolBar.add(Box.createHorizontalStrut(5));  // Add a separator to the ToolBar
                else
                    throw new xg_VerificationException("Child element '" + CurrentChild.getName()
                                                          + "' not of correct type to include in a toolbar",
                                                       CurrentChild.getStartOffset(),
                                                       CurrentChild.getEndOffset() );
            }
        }

    	TheToolBar.add(Box.createHorizontalGlue());
    }

    //*****************************************************************************
    /** Get the toolbar created by this element.
     *
     *  @return  The toolbar itself.
     */
    public JToolBar getToolBar()
    {
        return TheToolBar;
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return("ToolBar element '" + NodeName + "'");
    }
}

//*****************************************************************************
