//*****************************************************************************
/*
** FILE:   xu_ToolBarButtonElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    11May98  stevew  Created.
*/
package xu;

import xg.xg_Element;
import xg.xg_Node;
import xg.xg_VerificationException;

import eh.eh_Debug;

import com.sun.java.swing.Action;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JButton;

import java.awt.Insets;

//*****************************************************************************
/** An XML element to represent a Swing toolbar button.
*/
public class xu_ToolBarButtonElement extends xg_Element
{
    /** The toolbar button created by this element. */
    protected JButton          TheButton      = null;

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "ToolBarButton";

    /** The name of the attribute which holds the ID of this toolbar button. */
    public final static String IdAttName      = "Name";

    /** The name of the attribute which holds the tool tip for this toolbar button. */
    public final static String ToolTipAttName = "ToolTip";

    //*****************************************************************************
    /** Construct a toolbar button element with no type and no name.
     */
    public xu_ToolBarButtonElement()
    {
    }

    //*****************************************************************************
    /** Construct a toolbar button with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xu_ToolBarButtonElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK iff it has a 'Name'
     *  attribute and it lives inside a "FrameConfig".</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "xu_ToolBarButtonElement.verify: Verify '" + toString() + "'");

        // Obtain the toolbar button's ID from the "Name" attribute.
        String  NameValue = getAttributeValueVerified(IdAttName);

        TheButton = new JButton()
        {
            public float getAlignmentY()  { return 0.5f; }
	    };
        TheButton.setRequestFocusEnabled(false);
        TheButton.setMargin(new Insets(1, 1, 1, 1) );

        // Retrieve the document this toolbar button belongs to.
        xg_Node  RootNode = getRootNode();
        if (    RootNode == null
             || !(RootNode instanceof xu_FrameConfigDocument) )
            eh_Debug.add(4, "xu_ToolBarButtonElement.verify: toolbar button not within a 'xu_FrameConfigDocument', so cannot retrieve associated Action");
        else
        {
            xu_FrameConfigDocument  TheFrameConfigDocument = (xu_FrameConfigDocument)RootNode;

            // Retrieve this toolbar button's associated Action from the FrameConfig.
            Action  ButtonAction = TheFrameConfigDocument.getAction(NameValue);
   	        if (ButtonAction != null)
   	        {
   	            TheButton.addActionListener(ButtonAction);
	            TheButton.setActionCommand(NameValue);

                Object  ActionImageObject = ButtonAction.getValue(xu_ActionElement.ImageAttName);
    	        if (    ActionImageObject != null
    	             && ActionImageObject instanceof ImageIcon)
    	        {
    	            TheButton.setIcon((ImageIcon)ActionImageObject);
    	        }
   	        }
   	        else
   	            // Can't find an action with this name - so disable the menu option.
  	            TheButton.setEnabled(false);
  	    }

        // Obtain the toolbar button's tool tip text from the "ToolTip" attribute.
        String  ToolTipValue = getAttributeValue(ToolTipAttName);
	    if (ToolTipValue != null)
            TheButton.setToolTipText(ToolTipValue);
    }

    //*****************************************************************************
    /** Get the toolbar button created by this element.
     *
     *  @return  The toolbar button itself
     */
    public JButton getButton()
    {
        return TheButton;
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return("ToolBar button element '" + NodeName + "'");
    }
}

//*****************************************************************************
