//*****************************************************************************
/*
** FILE:   xu_MetalThemeFactory.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    29Jul98  stevew  Created, based on xm_NodeFactory.
*/
package xu;

import xm.xm_Factory;

import eh.eh_Debug;

import com.sun.java.swing.plaf.metal.MetalTheme;

import java.lang.Class;

//*****************************************************************************
/** Factory for generating Swing Metal theme objects, given a theme class name.
 */
public class xu_MetalThemeFactory extends xm_Factory
{
    /** The name of the class from which all Metal themes must derive. */
    public final static String  BaseThemeClassName = "com.sun.java.swing.plaf.metal.MetalTheme";

    //*****************************************************************************
    /** Create a Metal theme whose class name is InputThemeClassName.
     *
     *  @param  InputThemeClassName  The class name of the theme we want to create
     *  @return                      The newly-created theme
     *  @exception  Exception  We were unable to create the theme
     */
    static public MetalTheme createTheme(String  InputThemeClassName)
                                                         throws Exception
    {
        eh_Debug.add(7, "xu_MetalThemeFactory: Create theme of class "
                              + InputThemeClassName + "'");
        Class  ThemeClass = null;
        try
        {
            ThemeClass = Class.forName(InputThemeClassName);
        }
        catch (Exception  InputException)
        {
            throw new Exception("Theme class " + InputThemeClassName
                                   + " cannot be found: "
                                   + InputException);
        }

        // Make sure this class extends the usual class.
        checkClassType(ThemeClass, InputThemeClassName, BaseThemeClassName);

        // Create a theme.
        MetalTheme  NewTheme = null;
        try
        {
            NewTheme = (MetalTheme)ThemeClass.newInstance();
        }
        catch (Exception  InputException)
        {
            throw new Exception("Error instantiating " + InputThemeClassName
                                   + " (" + InputException + ")");
        }

        return NewTheme;
    }
}

//*****************************************************************************
