//*****************************************************************************
/*
** FILE:   xu_MenuItem.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    30Jul98  stevew  Created.
*/
package xu;

import xg.xg_AttList;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JMenuItem;

import java.awt.event.ActionEvent;

//*****************************************************************************
/** <p>A JMenuItem which has an attribute list. Its purpose is to be created
 *  from an XML configuration file with an arbitrary list of attributes, which
 *  can be interrogated by the action which it invokes. The benefit of this is
 *  that several menu items can be associated with a single action, but the
 *  behaviour of the action can be different for each one. (For example, the
 *  menu item may include the pathname of a file upon which it is to operate -
 *  such as for displaying help).</p>
 *
 *  <p>xu_MenuItem objects can be treated exactly the same as JMenuItem objects
 *  - this class offers exactly the same set of constructors. The *only*
 *  difference is the ability to set and retrieve an attribute list.</p>
 */
public class xu_MenuItem extends JMenuItem
{
    /** The attributes associated with this menu item. */
	protected xg_AttList  MenuItemAttList = null;

    //*****************************************************************************
    /** Default constructor, to create a menu item with no set text or icon.
     *
     *  @param InputActionName  The name of the action
     */
    public xu_MenuItem()
    {
    	super();
    }

    //*****************************************************************************
    /** Constructor, to create a menu item with an icon.
     *
     *  @param  InputIcon  The icon of the menu item.
     */
    public xu_MenuItem(Icon  InputIcon)
    {
        super(InputIcon);
    }

    //*****************************************************************************
    /** Constructor, to create a menu item with text.
     *
     *  @param  InputText  The text of the menu item.
     */
    public xu_MenuItem(String  InputText)
    {
        super(InputText);
    }

    //*****************************************************************************
    /** Constructor, to create a menu item with text and an icon.
     *
     *  @param  InputText  The text of the menu item.
     *  @param  InputIcon  The icon of the menu item.
     */
    public xu_MenuItem(String  InputText, Icon  InputIcon)
    {
        super(InputText, InputIcon);
    }

    //*****************************************************************************
    /** Constructor, to create a menu item with text and a keyboard mnemonic.
     *
     *  @param  InputText              The text of the menu item.
     *  @param  InputKeyboardMnemonic  The keyboard mnemonic of the menu item.
     */
    public xu_MenuItem(String  InputText, int  InputKeyboardMnemonic)
    {
        super(InputText, InputKeyboardMnemonic);
    }

    //*****************************************************************************
    /** Set the attributes associated with this menu item.
     */
    public void setAttList(xg_AttList  InputAttList)
    {
	    MenuItemAttList = InputAttList;
    }

    //*****************************************************************************
    /** Get the attributes associated with this menu item.
     *
     *  return  The attribute list of this item
     */
    public xg_AttList getAttList()
    {
	    return MenuItemAttList;
    }
}

//*****************************************************************************
