//*****************************************************************************
/*
** FILE:   xu_MenuElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    07May98  stevew  Created.
*/
package xu;

import xg.xg_Element;
import xg.xg_Node;
import xg.xg_VerificationException;

import eh.eh_Debug;

import com.sun.java.swing.JMenu;

//*****************************************************************************
/** An XML element to represent a Swing menu.
*/
public class xu_MenuElement extends xg_Element
{
    /** The menu created by this element. */
    protected JMenu            TheMenu            = new JMenu();

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName     = "Menu";

    /** The element type name used in XML for a menu separator. */
    public final static String SeparatorTypeName  = "Separator";

    /** The name of the attribute which holds the label to put on this menu. */
    public final static String LabelAttName       = "Label";

    //*****************************************************************************
    /** Construct a menu element with no name.
     */
    public xu_MenuElement()
    {
    }

    //*****************************************************************************
    /** Construct a menu with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xu_MenuElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if each of its children
     *  is an xu_MenuItemElement, an xu_MenuElement, an xg_Element of type "Separator"
     *  or not an xg_Element.</p>
     *
     * @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "xu_MenuElement.verify: Verify '" + toString() + "'");

        // Obtain the menu item's text from the "Label" attribute.
        String  LabelValue = getAttributeValueVerified(LabelAttName);
        TheMenu.setText(LabelValue);

        // Check the children are the right sort, and add them if they are.
        xg_Node  CurrentChild = null;

        for (int CurrentChildIndex = 0;
             CurrentChildIndex < getChildCount();
             CurrentChildIndex++)
        {
            CurrentChild = (xg_Node)getChildAt(CurrentChildIndex);

            // Check this child is of an acceptable type.
            if (CurrentChild instanceof xg.xg_Element)
            {
                if (CurrentChild instanceof xu.xu_MenuButtonGroupElement)
                    // Add the members of the button group in this element to the Menu.
                    addButtonGroupContents((xu.xu_MenuButtonGroupElement)CurrentChild);
                else if (CurrentChild instanceof xu.xu_MenuItemElement)
                    // Add the menu item in this element to the Menu.
                    TheMenu.add(((xu.xu_MenuItemElement)CurrentChild).getMenuItem());
                else if (CurrentChild instanceof xu.xu_MenuElement)
                    // Add the menu in this element to the Menu (as a pull-out menu).
                    TheMenu.add(((xu.xu_MenuElement)CurrentChild).getMenu());
                else if (CurrentChild.getName().equals(SeparatorTypeName) )
        		    TheMenu.addSeparator();  // Add a separator to the Menu
                else
                    throw new xg_VerificationException("Child element '" + CurrentChild.getName()
                                                          + "' not of correct type to include in a menu",
                                                       CurrentChild.getStartOffset(),
                                                       CurrentChild.getEndOffset() );
            }
        }
    }

    //*****************************************************************************
    /** Add the members of the button group in this element to the Menu.
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void addButtonGroupContents(xu_MenuButtonGroupElement  InputMenuButtonGroupElement)
                      throws xg_VerificationException
    {
        eh_Debug.add(8, "xu_MenuElement.addButtonGroupContents:");

        // Check the children are the right sort, and add them if they are.
        xg_Node  CurrentChild = null;

        for (int CurrentChildIndex = 0;
             CurrentChildIndex < InputMenuButtonGroupElement.getChildCount();
             CurrentChildIndex++)
        {
            CurrentChild = (xg_Node)InputMenuButtonGroupElement.getChildAt(CurrentChildIndex);

            // Check this child is of an acceptable type.
            if (CurrentChild instanceof xg.xg_Element)
            {
                if (CurrentChild instanceof xu.xu_MenuItemElement)
                    // Add the menu item in this element to the Menu.
                    TheMenu.add(((xu.xu_MenuItemElement)CurrentChild).getMenuItem());
                else if (CurrentChild instanceof xu.xu_MenuElement)
                    // Add the menu in this element to the Menu (as a pull-out menu).
                    TheMenu.add(((xu.xu_MenuElement)CurrentChild).getMenu());
                else if (CurrentChild.getName().equals(SeparatorTypeName) )
        		    TheMenu.addSeparator();  // Add a separator to the Menu
                else
                    throw new xg_VerificationException("Child element of button group '" + CurrentChild.getName()
                                                          + "' not of correct type to include in a menu",
                                                       CurrentChild.getStartOffset(),
                                                       CurrentChild.getEndOffset() );
            }
        }
    }

    //*****************************************************************************
    /** Get the menu created by this element.
     *
     *  @return  The menu itself.
     */
    public JMenu getMenu()
    {
        return TheMenu;
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return("Menu element '" + NodeName + "'");
    }
}

//*****************************************************************************
