//*****************************************************************************
/*
** FILE:   xu_MenubarElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    06May98  stevew  Created.
*/
package xu;

import xg.xg_Element;
import xg.xg_Node;
import xg.xg_VerificationException;

import eh.eh_Debug;

import com.sun.java.swing.JMenuBar;

//*****************************************************************************
/** An XML element to represent a Swing menubar.
*/
public class xu_MenuBarElement extends xg_Element
{
    /** The menubar created by this element. */
    protected JMenuBar         TheMenuBar      = new JMenuBar();

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName  = "MenuBar";

    //*****************************************************************************
    /** Construct a menubar element with no type and no name.
     */
    public xu_MenuBarElement()
    {
    }

    //*****************************************************************************
    /** Construct a menubar with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xu_MenuBarElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if each of its children
     *  is an xu_MenuElement or not an xg_Element.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "xu_MenuBarElement.verify: Verify '" + toString() + "'");
        xg_Node  CurrentChild = null;

        for (int CurrentChildIndex = 0;
             CurrentChildIndex < getChildCount();
             CurrentChildIndex++)
        {
            CurrentChild = (xg_Node)getChildAt(CurrentChildIndex);

            // Check this child is of an acceptable type.
            if (CurrentChild instanceof xg.xg_Element)
            {
                if (CurrentChild instanceof xu.xu_MenuElement)
                    // Add the menu in this element to the MenuBar.
                    TheMenuBar.add(((xu.xu_MenuElement)CurrentChild).getMenu());
                else
                    throw new xg_VerificationException("Child element '" + CurrentChild.getName()
                                                          + "' not of correct type to include in a menu bar",
                                                       CurrentChild.getStartOffset(),
                                                       CurrentChild.getEndOffset() );
            }
        }
    }

    //*****************************************************************************
    /** Get the menubar created by this element.
     *
     *  @return  The menubar itself.
     */
    public JMenuBar getMenuBar()
    {
        return TheMenuBar;
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return("MenuBar element '" + NodeName + "'");
    }
}

//*****************************************************************************
