//*****************************************************************************
/*
** FILE:   xu_LookAndFeelAction.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    29Jul98  stevew  Created.
*/
package xu;

import xg.xg_AttList;

import eh.eh_Debug;

import com.sun.java.swing.plaf.metal.MetalTheme;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.UnsupportedLookAndFeelException;

import java.awt.event.ActionEvent;

//*****************************************************************************
/** A button group action to be invoked by a menu group, each of whose menu
 *  items is expected to represent a Swing look-and-feel. When the
 *  actionPerformed method is invoked, obtain the attributes of the newly-
 *  selected menu item and change the look-and-feel of the ParentFrame to suit.
 */
public class xu_LookAndFeelAction extends xu_ButtonGroupAction
{
    /** This action's parent frame, to be passed to the dialog box we create. */
    protected JFrame  ParentFrame = null;

    //*****************************************************************************
    /** Constructor.
     *
     *  @param InputActionName  The name of the action
     */
    public xu_LookAndFeelAction(JFrame  InputParentFrame)
    {
    	super("look-and-feel");
        ParentFrame = InputParentFrame;
    }

    //*****************************************************************************
    /** The currently-selected button has changed.
     */
    public void actionPerformed(ActionEvent  InputActionEvent)
    {
        super.actionPerformed(InputActionEvent);
        conformToState();
    }

    //*****************************************************************************
    /** Take whatever steps are necessary to bring the Action into line with what
     *  the controlling check box wishes (as indicated by the value of StateFlag).
     *  This method may be called either when the associated menu item is selected
     *  (ie. called by actionPerformed) or during initialization.
     */
    public void conformToState()
    {
        xg_AttList  LookAndFeelAttList   = getAttList();
        String      LookAndFeelName      = LookAndFeelAttList.getAttributeValue("Name");
        //TBD Add error handling
        String      LookAndFeelClassName = LookAndFeelAttList.getAttributeValue("UIClass");
        //TBD Add error handling
        String      MetalThemeClassName  = LookAndFeelAttList.getAttributeValue("ThemeClass");
        //TBD Add error handling

        if (MetalThemeClassName != null)
            setMetalTheme(MetalThemeClassName);

        eh_Debug.add(7, "xu_LookAndFeelAction.actionPerformed: Change to '"
                           + LookAndFeelName + "' look and feel (index "
                           + ButtonGroupIndex + ")");
        try
        {
	  	    UIManager.setLookAndFeel(LookAndFeelClassName);
       	    SwingUtilities.updateComponentTreeUI(ParentFrame);
        }
        catch (Exception  InputException)
        {
		    // Error - unsupported look and feel.
//		    LookAndFeelMenuItem.setEnabled(false);
            eh_Debug.add(2, "xu_LookAndFeelAction.actionPerformed: '"
                               + LookAndFeelName + "' look and feel unsupported: "
                               + InputException);

		    // Set look and feel to default (which we assume is Metal - for
		    // the purposes of setting the current menu item).
		    try
		    {
//		        MetalMenuItem.setSelected(true);
		        UIManager.setLookAndFeel("com.sun.java.swing.plaf.metal.MetalLookAndFeel");
//		        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
		        SwingUtilities.updateComponentTreeUI(ParentFrame);
		    }
		    catch (Exception  InputMetalException)
		    {
                eh_Debug.add(2, "xu_LookAndFeelAction.actionPerformed: Could not load cross-platform look and feel: "
                                      + InputMetalException);
		    }
        }
    }

    //*****************************************************************************
    /** Set the Swing Metal theme to that defined in the named class.
     *
     *  param  InputMetalThemeClassName  The name of a Metal theme class
     */
    public void setMetalTheme(String  InputMetalThemeClassName)
    {
        eh_Debug.add(7, "xu_LookAndFeelAction.setMetalTheme: Set Metal theme to '"
                           + InputMetalThemeClassName + "'");
        try
        {
            MetalTheme  NewTheme = xu_MetalThemeFactory.createTheme(InputMetalThemeClassName);
            MetalLookAndFeel.setCurrentTheme(NewTheme);
		}
		catch (Exception  InputException)
		{
            eh_Debug.add(2, "xu_LookAndFeelAction.setMetalTheme: "
                                  + InputException);
		}
    }
}

//*****************************************************************************
