//*****************************************************************************
/*
** FILE:   xu_FrameConfigElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    02May98  stevew  Created, split from xt_XmlTestbedFrame.
**    09May98  stevew  Removed code which now lives in xu_FrameConfigManager.
*/
package xu;

import xg.xg_Element;

import eh.eh_Debug;

import java.net.URL;

//*****************************************************************************
/**
 * <p>xu_FrameConfigElement is an within which are expected to live other
 * elements which describe the configuration details for a frame. This class
 * has few responsibilities itself (child classes and the document it belongs
 * will do all the hard work). The only real thing this class does is know
 * about its 'Class' attribute, and to be able to use its value to turn
 * relative pathnames into full URLs for resources.</p>
 */
public class xu_FrameConfigElement extends xg_Element
{
    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "FrameConfig";

    /** The name of the attribute which holds the name of the Java class of the
     *  Frame for which this configuration was designed. */
    public final static String ClassAttName   = "Class";

    /** Suffix applied to the key used in resource file lookups for images. */
    public static final String ImageSuffix    = "Image";

    //*****************************************************************************
    /**
     * Constructor.
     */
/*    public xu_FrameConfigElement()
    {
    }
*/
    //*****************************************************************************
    /**
     * Get the value of the URL whose name is InputResourceName.
     */
    public URL convertToURL(String  InputValue)
    {
        eh_Debug.add(9, "xu_FrameConfigElement.convertToURL:");
    	URL  ResourceURL = null;
    	if (InputValue != null)
    	{
            String  FrameClassName = getAttributeValue(ClassAttName);
            if (FrameClassName == null)
                eh_Debug.add(2, "xu_FrameConfigElement.convertToURL:" + RegisteredName
                                      + " does not have a '" + InputValue + "' attribute");
            else
            {
                try
                {
                    Class  FrameClass = Class.forName(FrameClassName);
    	            ResourceURL = FrameClass.getResource(InputValue);
                }
                catch (Exception  InputException)
                {
                    eh_Debug.add(2, "xu_FrameConfigElement.convertToURL: Cannot find class '"
                                          + FrameClassName + "' (" + InputException + ")");
                }
    	    }
    	}

    	if (ResourceURL != null)
            eh_Debug.add(7, "xu_FrameConfigElement.convertToURL: Resource '"
                                 + InputValue + "' is URL '" + ResourceURL.toString() + "'");
    	return ResourceURL;
    }
}

//*****************************************************************************
