//*****************************************************************************
/*
** FILE:   xu_FrameConfigDocument.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    10May98  stevew  Created.
*/
package xu;

import xg.xg_Document;

import eh.eh_Debug;

import com.sun.java.swing.Action;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

//*****************************************************************************
/** An XML document for configuration details. It provides a limited degree of
 *  support for the elements it contains (of which it has no knowledge - since
 *  they need to know about it), in the form of actions which they may
 *  associate themselves, and a bundle of text resources.
 */
public class xu_FrameConfigDocument extends xg_Document
{
    /** Text resources. */
    ResourceBundle  TextResourceBundle = null;

    /** Table of the actions supported by the caller. */
    Hashtable       ActionsHashtable   = new Hashtable();

    //*****************************************************************************
    /** Default constructor.
     */
/*    public xu_FrameConfigDocument()
    {
    }
*/
    //*****************************************************************************
    /** Add an array of actions to the array of known actions.
     */
    public void registerActions(Action[]  InputActionArray)
    {
        eh_Debug.add(7, "xu_FrameConfigDocument.registerActions");
    	for (int i = 0; i < InputActionArray.length; i++)
    	{
            registerAction(InputActionArray[i]);
    	}
    }

    //*****************************************************************************
    /** Add the InputAction to the hashtable of known actions.
     */
    public void registerAction(Action  InputAction)
    {
        eh_Debug.add(7, "xu_FrameConfigDocument.registerAction: '"
                              + InputAction.getValue(Action.NAME) + "'");
  	    ActionsHashtable.put(InputAction.getValue(Action.NAME), InputAction);
    }

    //*****************************************************************************
    /** Load resources.
     *
     *  @param  InputConfigFileName  The name of the configuration file from which
     *                                to obtain information. It omits its '.properties'
     *                                ending, since locale-specific endings are tried
     *                                as appropriate.
     *  @return                      A flag indicating whether the load was successful
     */
    public boolean loadResources(String  InputConfigFileName)
    {
        eh_Debug.add(7, "xu_FrameConfigDocument: Load resources from '" + InputConfigFileName + "'");
        boolean  SuccessFlag = true;  // Be optimistic!
        try
        {
            TextResourceBundle = ResourceBundle.getBundle(InputConfigFileName,
                                                          Locale.getDefault());
            eh_Debug.add(7, "xu_FrameConfigDocument: Resources loaded");
        }
        catch (MissingResourceException  InputException)
        {
            eh_Debug.add(2, "xu_FrameConfigDocument: Resource file '" + InputConfigFileName
                                  + "'not found:" + InputException);
            SuccessFlag = false;
        }
        return SuccessFlag;
    }

    //*****************************************************************************
    /** Get the action registered under the given name.
     */
    public Action getAction(String  InputActionName)
    {
    	return (Action)ActionsHashtable.get(InputActionName);
    }

    //*****************************************************************************
    /** Get the value of the string whose name is InputResourceName.
     */
    public String getResourceString(String  InputResourceName)
    {
        eh_Debug.add(8, "xu_FrameConfigDocument.getResourceString:");
    	String  ResourceValue = null;
    	try
    	{
    	    ResourceValue = TextResourceBundle.getString(InputResourceName);
            eh_Debug.add(7, "xu_FrameConfigDocument.getResourceString: Resource '"
                                  + InputResourceName
                                  + "' is '" + ResourceValue + "'");
    	}
    	catch (MissingResourceException  InputMissingResourceException)
    	{
            eh_Debug.add(7, "xu_FrameConfigDocument.getResourceString: Cannot find resource '"
                                  + InputResourceName + "'");
    	}
    	return ResourceValue;
    }

    //*****************************************************************************
    /** Get the hashtable of known actions.
     */
    public Hashtable getActionsHashtable()
    {
    	return ActionsHashtable;
    }

    //*****************************************************************************
    /** Get the text resource bundle.
     */
    public ResourceBundle getResourceBundle()
    {
    	return TextResourceBundle;
    }

    //*****************************************************************************
    /** Output a list of all registered actions to debug.
     */
    public void listToDebug()
    {
        eh_Debug.add(1, "The actions currently registered are:");

        eh_Debug.incrementIndentLevel();

        Enumeration  ActionEnumeration = ActionsHashtable.elements();
        Action       CurrentAction     = null;
        Object       CurrentActionName = null;

        while (ActionEnumeration.hasMoreElements() )
        {
            CurrentAction     = (Action)ActionEnumeration.nextElement();
            CurrentActionName = CurrentAction.getValue(Action.NAME);
            if (CurrentActionName != null)
                eh_Debug.add(1, CurrentActionName.toString() );
        }

        eh_Debug.decrementIndentLevel();
    }
}

//*****************************************************************************
