//*****************************************************************************
/*
** FILE:   xu_Frame.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    30Jul98  stevew  Created, split from xt_XmlTestbedFrame.
*/
package xu;

import xm.xm_StatusBar;

import oh.oh_HelpAction;

import xu.xu_FrameConfigManager;

import eh.eh_Debug;

import com.sun.java.swing.border.Border;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Action;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JToolBar;
import com.sun.java.swing.JViewport;

import java.net.URL;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

//*****************************************************************************
/** xu_Frame is a JFrame with support for loading a menu bar and/or a toolbar
 *  from an XML configuration file.
 */
public class xu_Frame extends JFrame
{
    /** <P>The frame from which this class has been invoked. This may be null,
     *  in which case it is assumed to be the 'master' frame. Whether this is
     *  null or not is used to decide whether to terminate the whole
     *  application when we exit from here.</P>
     *
     *  <P>Note that this attribute is public so it can be accessible to
     *  inner classes of derived classes.</P> */
    public    JFrame                 ParentFrame = null;

    /** This class's main frame. */
    public    JFrame                 MainFrame;

    public    xm_StatusBar           MainStatusBar;

    // Attributes related to the loading of text resources.
    /** Frame configuration manager reluctantly made public to allow inner
     *  classes of derived classes to access it. */
    public    xu_FrameConfigManager  TheFrameConfigManager = null;

    protected ResourceBundle         TextResourceBundle    = null;

    public    String                 BasicFrameTitle       = null;

    // Actions.
	protected ExitAction             TheExitAction         = new ExitAction();

	protected oh_HelpAction          TheHelpAction         = null;  // Needs ParentFrame!

    //*****************************************************************************
    /** Default constructor. Create a new xu_Frame at a default screen
     *  location.
     *
     *  @param  InputParentFrame  The master frame from which this frame is being
     *                             called
     */
    public xu_Frame(JFrame  InputParentFrame)
    {
        eh_Debug.add(5, "xu_Frame: Construct testbed frame");
        ParentFrame = InputParentFrame;
        MainFrame   = this;
    }

    //*****************************************************************************
    /** Default constructor. Create a new xu_Frame at a default screen
     *  location.
     */
    public xu_Frame()
    {
        eh_Debug.add(5, "xu_Frame: Construct testbed frame");
        MainFrame = this;
    }

    //*****************************************************************************
    /** Initialise the frame configuration, including setting up the table of
     *  supported actions.
     *
     *  @param  InputConfigFilePathname  The name of the configuration file to load
     */
    protected void loadConfig(String  InputConfigFilePathname)
    {
        eh_Debug.add(7, "xu_Frame.loadConfig: Load config file '"
                                        + InputConfigFilePathname + "'");
        TheFrameConfigManager = new xu_FrameConfigManager();

        TextResourceBundle = TheFrameConfigManager.getResourceBundle();

        registerActions();

    	// Load the frame's configuration from its XML configuration file. (This
    	// is done after registering the actions, so the actions can be associated
    	// with menu items and toolbar buttons during the load.)
    	int  StandardDebugLevel = eh_Debug.getDebugBoxImportanceLevel();
    	if (StandardDebugLevel > 3)
            eh_Debug.setDebugBoxImportanceLevel(3);

   	    TheFrameConfigManager.load(InputConfigFilePathname);

        eh_Debug.setDebugBoxImportanceLevel(StandardDebugLevel);
    }

    //*****************************************************************************
    /** Register the actions supported by this frame.
     */
    protected void registerActions()
    {
        // Create those actions which need to know about the MainFrame.
	    TheHelpAction = new oh_HelpAction(MainFrame);

    	// Register actions implemented in by the inner classes herein.
	    TheFrameConfigManager.registerAction(TheExitAction);
        TheFrameConfigManager.registerAction(TheHelpAction);
    }

    //*****************************************************************************
    /** Initialise the input/control panel at the top of the main frame.
     */
    protected void initControlPanel()
    {
        eh_Debug.add(7, "xu_Frame.initControlPanel");
	    Border  StandardBorder = BorderFactory.createEtchedBorder();
        JPanel  ControlPanel   = new JPanel();
    	ControlPanel.setLayout(new BorderLayout());

    	// Add menu bar (if one has been configured).
    	JMenuBar  MainMenuBar = TheFrameConfigManager.getMenuBar();
        if (MainMenuBar != null)
        {
	        MainMenuBar.setBorder(StandardBorder);
    	    ControlPanel.add("North", MainMenuBar);
    	}

    	// Add tool bar (if one has been configured).
        JToolBar  MainToolBar = TheFrameConfigManager.getToolBar();
        if (MainToolBar != null)
        {
	        MainToolBar.setBorder(StandardBorder);
    	    ControlPanel.add("South", MainToolBar);
    	}

	    getContentPane().add("North", ControlPanel);
    }

    //*****************************************************************************
    /** Get the value of the string whose name is InputResourceName.
     */
    protected String getResourceString(String  InputResourceName)
    {
        return TheFrameConfigManager.getResourceString(InputResourceName);
    }

    //*****************************************************************************
    //**Action*inner*classes*******************************************************
    //*****************************************************************************
    /** Exit action. If this is the master frame (ie. has no parent), then
     *  terminate the application; otherwise just close this frame.
     */
    protected class ExitAction extends AbstractAction
    {
        //*****************************************************************************
    	ExitAction()
    	{
            super("exit");
    	}

        //*****************************************************************************
        public void actionPerformed(ActionEvent  InputActionEvent)
        {
            if (ParentFrame == null)
                // This is the master frame - so stop altogether.
    	        System.exit(0);
            else
                // We were called from another frame - so make them responsible
                // for stopping. We just kill ourself.
                dispose();
    	}
    }
}

//*****************************************************************************
