//*****************************************************************************
/*
** FILE:   xu_DatabaseDriverElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    22May98  stevew  Created.
*/
package xu;

import xg.xg_Element;
import xg.xg_VerificationException;

import java.sql.Driver;
import java.sql.DriverManager;

import eh.eh_Debug;

//*****************************************************************************
/** An XML element to represent a JDBC database driver. Its purpose is to load
 *  a database driver (when its verify() method is called).
 */
public class xu_DatabaseDriverElement extends xg_Element
{
    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "DatabaseDriver";

    /** The name of the attribute which holds the name of the driver class. */
    public final static String ClassAttName   = "Class";

    //*****************************************************************************
    /** Construct a database driver element with no type and no name.
     */
    public xu_DatabaseDriverElement()
    {
    }

    //*****************************************************************************
    /** Construct a database driver element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xu_DatabaseDriverElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it possesses a
     *  'Class' attribute which names a valid database driver class.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "xu_DatabaseDriverElement.verify: Verify '" + toString() + "'");

        // Obtain the menu item's ID from the "Class" attribute.
        String  DriverClassName = getAttributeValueVerified(ClassAttName);

        try
        {
            // Load the named driver class.
            Class.forName(DriverClassName);
//            Class  DriverClass = Class.forName(DriverClassName);
            eh_Debug.add(2, "xu_DatabaseDriverElement.verify: Loaded driver '" + DriverClassName + "'");
        }
        catch (Exception InputException)
        {
            throw new xg_VerificationException("Error loading database driver '"
                                                  + DriverClassName + "': "
                                                  + InputException);
        }
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return("Database driver element '" + NodeName + "'");
    }
}

//*****************************************************************************
