//*****************************************************************************
/*
** FILE:   xu_CheckBoxAction.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    11May98  stevew  Created.
*/
package xu;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JCheckBoxMenuItem;

import java.awt.event.ActionEvent;

//*****************************************************************************
/** An action intended to be associated with a check box menu item, such that
 *  it is invoked when the menu item is clicked. The action thus indicates the
 *  state of the menu item, and can be accessed to determine its state so that
 *  the caller need never deal with the menu item object itself. When the menu
 *  item is clicked, the actionPerformed method is invoked, and the ActionEvent
 *  it is passed gives details of the menu item's state.
 */
public class xu_CheckBoxAction extends AbstractAction
{
    /** The associated check box menu item. */
	protected JCheckBoxMenuItem  AssociatedCheckBoxMenuItem = null;

    /** Flag reflecting the current state (checked or not) of the associated menu
     *  item. It defaults to 'false'. */
    protected boolean            StateFlag                  = false;

    //*****************************************************************************
    /** Constructor.
     *
     *  @param InputActionName  The name of the action
     */
    public xu_CheckBoxAction(String  InputActionName)
    {
    	super(InputActionName);
    }

    //*****************************************************************************
    /** Something's happened: record where the event came from, and determine the
     *  state of the check box menu item.
     */
    public void actionPerformed(ActionEvent  InputActionEvent)
    {
        if (InputActionEvent.getSource() instanceof JCheckBoxMenuItem)
        {
	        AssociatedCheckBoxMenuItem = (JCheckBoxMenuItem)InputActionEvent.getSource();
            StateFlag                  = AssociatedCheckBoxMenuItem.getState();
        }
    }

    //*****************************************************************************
    /** Set the current state of this action. This is intended to be used at
     *  initialisation time (to set the initial state, say, according to the value
     *  in a configuration file).
     */
    public void setState(boolean  InputStateFlag)
    {
	    StateFlag = InputStateFlag;
    }

    //*****************************************************************************
    /** Get the menu item associated with this action.
     */
    public JCheckBoxMenuItem getAssociatedCheckBoxMenuItem()
    {
	    return AssociatedCheckBoxMenuItem;
    }

    //*****************************************************************************
    /** Get the current state (checked or not) of the associated menu item.
     */
    public boolean getState()
    {
	    return StateFlag;
    }
}

//*****************************************************************************
