//*****************************************************************************
/*
** FILE:   xu_ButtonGroupAction.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    12May98  stevew  Created.
*/
package xu;

import xg.xg_AttList;

import eh.eh_Debug;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JRadioButtonMenuItem;

import java.awt.event.ActionEvent;

import java.util.Vector;

//*****************************************************************************
/** An action intended to be associated with a button group, such that it is
 *  invoked when a different button in the group is selected. In this
 *  situation, the actionPerformed method is invoked, and the ActionEvent it is
 *  passed gives details of which is now the current button.
 */
public class xu_ButtonGroupAction extends AbstractAction
{
    /** The currently-selected button. */
	JRadioButtonMenuItem  CurrentRadioButton = null;

    /** Index giving the relative position in the group of the currently-
     *  selected button. */
    int                   ButtonGroupIndex   = -1;

    /** List of the attribute lists of the menu items. That is, the attribute list
     *  of the XML element which created each menu item has its attribute list
     *  copied here so that it may be retrieved by the calling application without
     *  it having to know anything about which element it came from. */
    Vector                AttListVector      = new Vector();

    //*****************************************************************************
    /** Constructor.
     *
     *  @param InputActionName  The name of the action
     */
    public xu_ButtonGroupAction(String  InputActionName)
    {
    	super(InputActionName);
    }

    //*****************************************************************************
    /** The currently-selected button has changed.
     */
    public void actionPerformed(ActionEvent  InputActionEvent)
    {
	    CurrentRadioButton = (JRadioButtonMenuItem)InputActionEvent.getSource();
        ButtonGroupIndex   = InputActionEvent.getID();  // Not its intended role!
    }

    //*****************************************************************************
    /** Add an attribute list to the end of the list of attribute lists. We assume
     *  there will be a call made for each button in the group, so that when a
     *  request is made to retrieve them, the index will point to the right one.
     *
     *  param  InputAttList  The attribute list of the currently-selected item
     */
    public void addAttList(xg_AttList  InputAttList)
    {
	    AttListVector.addElement(InputAttList);
    }

    //*****************************************************************************
    /** Nominate which button is currently selected.
     */
    public void setIndex(int  InputButtonGroupIndex)
    {
	    ButtonGroupIndex = InputButtonGroupIndex;
    }

    //*****************************************************************************
    /** Get the currently-selected button.
     */
    public JRadioButtonMenuItem getCurrentRadioButton()
    {
	    return CurrentRadioButton;
    }

    //*****************************************************************************
    /** Get the relative position in the group of the currently-selected button.
     */
    public int getIndex()
    {
	    return ButtonGroupIndex;
    }

    //*****************************************************************************
    /** Get the attributes associated with the currently-selected button (ie.
     *  the attributes from the XML element from which it was created).
     *
     *  return  The attribute list of the currently-selected item
     */
    public xg_AttList getAttList()
    {
        xg_AttList  CurrentAttList = null;
        if (ButtonGroupIndex > -1)
	        CurrentAttList = (xg_AttList)AttListVector.elementAt(ButtonGroupIndex);
        else
            eh_Debug.add(3, "xu_ButtonGroupAction.getAttList: Button group action not properly initialised");
        return CurrentAttList;
    }
}

//*****************************************************************************
