//*****************************************************************************
/*
** FILE:   xu_ActionElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    09May98  stevew  Created.
*/
package xu;

import xg.xg_Element;
import xg.xg_Node;
import xg.xg_VerificationException;

import eh.eh_Debug;

import com.sun.java.swing.Action;
import com.sun.java.swing.ImageIcon;

import java.net.URL;

//*****************************************************************************
/** An XML element to represent information about a Swing Action.
*/
public class xu_ActionElement extends xg_Element
{
    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "Action";

    /** The name of the attribute which holds the ID of this action. */
    public final static String IdAttName      = "Name";

    /** The name of the attribute which holds the relative pathname of the
     *  image associated with this action (to be used on menus and toolbars). */
    public final static String ImageAttName   = "Image";

    //*****************************************************************************
    /** Construct an action element with no type and no name.
     */
    public xu_ActionElement()
    {
    }

    //*****************************************************************************
    /** Construct an action with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xu_ActionElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it has a 'Name'
     *  attribute and has an 'Image' attribute.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "xu_ActionElement.verify: Verify '" + toString() + "'");

        // Obtain the action's ID from the "Name" attribute.
        String  NameValue = getAttributeValueVerified(IdAttName);

        // Obtain the relative pathname of the action's image from the "Image" attribute.
        String  ImageValue = getAttributeValueVerified(ImageAttName);

        // Retrieve the FrameConfigElement this element belongs to.
        xg_Node  AncestorNode = getAncestorOfType(xu_FrameConfigElement.RegisteredName);
        if (    AncestorNode == null
             || !(AncestorNode instanceof xu_FrameConfigElement) )
            throw new xg_VerificationException("Action not within a '" + xu_FrameConfigElement.RegisteredName + "'",
                                               getStartOffset(),
                                               getEndOffset() );
        xu_FrameConfigElement  TheFrameConfigElement = (xu_FrameConfigElement)AncestorNode;

        // Retrieve the FrameConfigDocument this element belongs to.
        xg_Node  RootNode = getRootNode();
        if (    RootNode == null
             || !(RootNode instanceof xu_FrameConfigDocument) )
        {
            eh_Debug.add(4, "Action not within an 'xu_FrameConfigDocument' object");
            return;
        }
        xu_FrameConfigDocument  TheFrameConfigDocument = (xu_FrameConfigDocument)RootNode;

        // Retrieve the associated Action from the FrameConfigDocument.
        Action  TheAction = TheFrameConfigDocument.getAction(NameValue);
   	    if (TheAction == null)
            eh_Debug.add(2, "xu_ActionElement.verify: Action '" + NameValue
                                  + "' not currently registered");
        else
        {
   	        URL  ImageURL = TheFrameConfigElement.convertToURL(ImageValue);
    	    if (ImageURL != null)
    	    {
    	        // Create an image and put it in the action itself.
    	        ImageIcon  ActionImageIcon = new ImageIcon(ImageURL);
    	        TheAction.putValue(ImageAttName, ActionImageIcon);
    	    }
   	    }
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return (NodeName + " '" + getAttributeValue(IdAttName) + "'");
    }
}

//*****************************************************************************
