/* 
 * @(#)DemoMetalTheme.java	1.1 98/03/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package xu;

import com.sun.java.swing.plaf.metal.DefaultMetalTheme;
import com.sun.java.swing.plaf.metal.MetalIconFactory;
import com.sun.java.swing.plaf.ColorUIResource;
import com.sun.java.swing.plaf.FontUIResource;
import com.sun.java.swing.UIDefaults;
import java.awt.Font;

/**
 * This class describes a theme using large fonts.
 * It's great for giving demos of your software to a group
 * where people will have trouble seeing what you're doing.
 *
 * @version 1.1 03/10/98
 * @author Steve Wilson
 */
public class DemoMetalTheme extends RedMetalTheme {
//public class DemoMetalTheme extends DefaultMetalTheme {

    public String getName() { return "Presentation"; }

    private final FontUIResource controlFont = new FontUIResource("Dialog", Font.BOLD, 18);
    private final FontUIResource systemFont = new FontUIResource("Dialog", Font.PLAIN, 18);
    private final FontUIResource userFont = new FontUIResource("SansSerif", Font.PLAIN, 18);
    private final FontUIResource smallFont = new FontUIResource("Dialog", Font.PLAIN, 14);

    public FontUIResource getControlTextFont() { return controlFont;}
    public FontUIResource getSystemTextFont() { return systemFont;}
    public FontUIResource getUserTextFont() { return userFont;}
    public FontUIResource getMenuTextFont() { return controlFont;}
    public FontUIResource getWindowTitleFont() { return controlFont;}
    public FontUIResource getSubTextFont() { return smallFont;}

    public void addCustomEntriesToTable(UIDefaults table) {
         super.addCustomEntriesToTable(table);

         final int internalFrameIconSize = 16;
         table.put("InternalFrameTitlePane.closeIcon", MetalIconFactory.getInternalFrameCloseIcon(internalFrameIconSize));
         table.put("InternalFrameTitlePane.maximizeIcon", MetalIconFactory.getInternalFrameMaximizeIcon(internalFrameIconSize));
         table.put("InternalFrameTitlePane.iconizeIcon", MetalIconFactory.getInternalFrameMinimizeIcon(internalFrameIconSize));
         table.put("InternalFrameTitlePane.altMaximizeIcon", MetalIconFactory.getInternalFrameAltMaximizeIcon(internalFrameIconSize));



         table.put( "ScrollBar.width", new Integer(21) );



    }

}
