/*
** FILE:   xt_TreeCellRenderer.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    23Mar98  stevew  Created, based on Swing SampleTree demo class
**                      SampleTreeCellRenderer.
*/
package xt;

import xg.xg_Node;

import eh.eh_Debug;

import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.TreeCellRenderer;

import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;

//*****************************************************************************
/** xt_TreeCellRenderer draws an XML node within a tree.
 */
public class xt_TreeCellRenderer extends JLabel implements TreeCellRenderer
{
    /** Whether or not the item that was last configured is selected. */
    protected boolean             SelectedFlag;

    /** Font used if the string to be displayed isn't a font. */
    static protected Font         DefaultFont;

    /** Icon to use when the item is collapsed. */
    static protected ImageIcon    CollapsedIcon;

    /** Icon to use when the item is expanded. */
    static protected ImageIcon    ExpandedIcon;

    /** Colour to use for the background when selected. */
    static protected final Color  SelectedBackgroundColor = Color.yellow;

    //*****************************************************************************
    static
    {
        eh_Debug.add(7, "xt_TreeCellRenderer: Load font and icons");
	    try
	    {
	        DefaultFont = new Font("SansSerif", 0, 12);
	    }
	    catch (Exception  InputException)
	    {
	        eh_Debug.add(4, "xt_TreeCellRenderer: Couldn't load font: " + InputException);
	    }

	    try
	    {
	        CollapsedIcon = new ImageIcon("images/collapsed.gif");
	        ExpandedIcon  = new ImageIcon("images/expanded.gif");
	    }
	    catch (Exception  InputException)
	    {
	        eh_Debug.add(4, "xt_TreeCellRenderer: Couldn't load icon image: " + InputException);
	    }
    }

    //*****************************************************************************
    /** Constructor.
      */
    public xt_TreeCellRenderer()
    {
        setFont(DefaultFont);
    }

    //*****************************************************************************
    /** This is messaged from JTree whenever it needs to get the size of the
      * component or it wants to draw it.
      * This attempts to set the font based on value, which will be a TreeNode.
      */
    public Component getTreeCellRendererComponent(JTree    InputTree,
                                                  Object   InputNode,
					                              boolean  InputSelectedFlag,
					                              boolean  InputExpandedFlag,
					                              boolean  InputLeafFlag,
					                              int      InputRowNum,
						                          boolean  InputHasFocusFlag)
    {
//	    eh_Debug.add(8, "xt_TreeCellRenderer.getTreeCellRendererComponent:");  //TEMP
	    // Update the selected flag for the next paint.
	    SelectedFlag = InputSelectedFlag;

//	    String  stringValue = InputTree.convertValueToText(InputNode,
//	                                                       SelectedFlag,
//					                                       InputExpandedFlag,
//					                                       InputLeafFlag,
//					                                       InputRowNum,
//					                                       InputHasFocusFlag);
//        eh_Debug.add(7, "xt_TreeCellRenderer.getTreeCellRendererComponent: stringValue is '" + stringValue + "'");

//	    xg_Node  CurrentNode = (xg_Node)((DefaultMutableTreeNode)InputNode).getUserObject();
	    xg_Node  CurrentNode = (xg_Node)InputNode;
//	    eh_Debug.add(8, "xt_TreeCellRenderer.getTreeCellRendererComponent: for "
//	                              + CurrentNode);  //TEMP

	    // Set the text and the tooltip text.
        String  SummaryString = CurrentNode.toString();
        setText(SummaryString);
	    setToolTipText(SummaryString + ", position "
	                      + CurrentNode.getStartOffset() + "-"
	                      + CurrentNode.getEndOffset());

	    // Set the icon image.
	    if (InputLeafFlag)
	        setIcon(null);
	    else if (InputExpandedFlag)
	        setIcon(ExpandedIcon);
	    else
	        setIcon(CollapsedIcon);

	    // Set the colour and the font based on the xg_Node CurrentNode.
        setForeground(Color.black);
    	if (InputHasFocusFlag)
	        setForeground(Color.red);
	    else
	        setForeground(Color.black);

//	    eh_Debug.add(8, "xt_TreeCellRenderer.getTreeCellRendererComponent: return");  //TEMP
	    return this;
    }

    //*****************************************************************************
    /** paint is subclassed to draw the background correctly. JLabel currently
      * does not allow backgrounds other than white, and it also fills behind the
      * icon (which isn't desirable).
      */
    public void paint(Graphics  InputGraphics)
    {
//        eh_Debug.add(8, "xt_TreeCellRenderer.paint:");  //TEMP
	    Color  BackgroundColor;
    	if (SelectedFlag)
	        BackgroundColor = SelectedBackgroundColor;
        else
        {
	        Container  ParentContainer = getParent();
	        if (ParentContainer != null)
	            // Pick up background colour from parent (which will come from
	            // the JTree we're contained in).
	            BackgroundColor = ParentContainer.getBackground();
	        else
	            BackgroundColor = getBackground();
	    }
	    InputGraphics.setColor(BackgroundColor);

	    Icon   CellIcon = getIcon();
	    if (CellIcon != null && getText() != null)
	    {
	        int  offset = CellIcon.getIconWidth() + getIconTextGap();

	        InputGraphics.fillRect(offset,
	                               0,
	                               getWidth() - 1 - offset,
		                           getHeight() - 1);
	    }
	    else
	        InputGraphics.fillRect(0, 0, getWidth() - 1, getHeight() - 1);

	    super.paint(InputGraphics);
//        eh_Debug.add(8, "xt_TreeCellRenderer.paint: return");  //TEMP
    }
}

//*****************************************************************************
