/*
** FILE:   xt_StyledEditFrame.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    18Jul98  stevew  Created, based on xt_SimpleEditFrame.
*/
package xt;

import xv.xv_XmlEditorKit;

import xm.xm_DocumentModel;

import eh.eh_Debug;

//import com.sun.java.swing.event.DocumentEvent;
//import com.sun.java.swing.event.DocumentListener;

import com.sun.java.swing.Action;
import com.sun.java.swing.JEditorPane;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JViewport;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;

//*****************************************************************************
/** xt_StyledEditFrame is an internal frame containing just a text area for the
 *  display and editing of the source of an XML document. It has knowledge of
 *  the xm_DocumentModel which it displays, and can be notified of document
 *  change events relating to it.
 */
public class xt_StyledEditFrame extends    xt_DocumentFrame
//                                implements DocumentListener
{
    /** The edit area itself. */
    JEditorPane  SourceEditorPane = new JEditorPane();

    //*****************************************************************************
    /** Constructor.
      */
    public xt_StyledEditFrame(xm_DocumentModel  InputDocumentModel,
                              String            InputFrameTitle)
    {
        super(InputDocumentModel, InputFrameTitle);
	    eh_Debug.add(7, "xt_StyledEditFrame:");  //TEMP

	    Container  EditContentPane = getContentPane();
	    EditContentPane.setLayout(new BorderLayout());

	    // Initialise the source edit JEditorPane.
	    eh_Debug.add(6, "xt_StyledEditFrame: Initialise editor pane");  //TEMP
	    xv_XmlEditorKit  TheXmlEditorKit = new xv_XmlEditorKit();
	    eh_Debug.add(6, "xt_StyledEditFrame: setEditorKitForContentType");  //TEMP
	    SourceEditorPane.setEditorKitForContentType("text/xml", TheXmlEditorKit);
	    SourceEditorPane.setContentType("text/xml");
	    SourceEditorPane.setFont(new Font("Courier", Font.PLAIN, 12));
//	    SourceEditorPane.setTabSize(4);
	    eh_Debug.add(6, "xt_StyledEditFrame: setDocument on editor pane");  //TEMP
	    SourceEditorPane.setDocument(TheDocumentModel);
	    SourceEditorPane.setBorder(null);
        SourceEditorPane.requestFocus();

        // Scroller.
    	JScrollPane  EditScrollPane = new JScrollPane();
    	JViewport    EditViewport   = EditScrollPane.getViewport();
    	EditViewport.add(SourceEditorPane);
   	    EditViewport.setBackingStoreEnabled(false);

    	JPanel       EditPanel = new JPanel();
    	EditPanel.setLayout(new BorderLayout());
    	EditPanel.add("Center", EditScrollPane);
    	EditContentPane.add("Center", EditPanel);
    }

    //*****************************************************************************
    /** Retrieve the editor pane in which the source is displayed and edited.
     *
     *  @return  The edit source editor pane
     */
    public JEditorPane getSourceEditorPane()
    {
	    return SourceEditorPane;
    }

    //*****************************************************************************
    /** Retrieve an array of the actions supported by this type of edit area.
     *
     *  @return  An array of the actions supported by this class
     */
    static public Action[] getActions()
    {
        JEditorPane  TempEditorPane = new JEditorPane();
	    return(TempEditorPane.getActions() );
    }
}

//*****************************************************************************
