/*
** FILE:   xt_SimpleEditFrame.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    13Jun98  stevew  Created, split from xt_XmltestbedFrame.
*/
package xt;

import xm.xm_DocumentModel;

//import eh.eh_Debug;

import com.sun.java.swing.plaf.metal.MetalLookAndFeel;

//import com.sun.java.swing.event.DocumentEvent;
//import com.sun.java.swing.event.DocumentListener;

import com.sun.java.swing.Action;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JViewport;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;

//*****************************************************************************
/** xt_SimpleEditFrame is an internal frame containing just a text area for the
 *  display and editing of the source of an XML document. It has knowledge of
 *  the xm_DocumentModel which it displays, and can be notified of document
 *  change events relating to it.
 */
public class xt_SimpleEditFrame extends    xt_DocumentFrame
//                                implements DocumentListener
{
    /** The edit area itself. */
    JTextArea  SourceTextArea = new JTextArea();

    //*****************************************************************************
    /** Constructor.
      */
    public xt_SimpleEditFrame(xm_DocumentModel  InputDocumentModel,
                              String            InputFrameTitle)
    {
        super(InputDocumentModel, InputFrameTitle);
//	    eh_Debug.add(7, "xt_SimpleEditFrame:");  //TEMP

	    Container  EditContentPane = getContentPane();
	    EditContentPane.setLayout(new BorderLayout());

	    // Initialise the source edit JTextArea.
	    setEditFont();
	    SourceTextArea.setTabSize(4);
	    SourceTextArea.setDocument(TheDocumentModel);
	    SourceTextArea.setBorder(null);
        SourceTextArea.requestFocus();

        // Scroller.
    	JScrollPane  EditScrollPane = new JScrollPane();
    	JViewport    EditViewport   = EditScrollPane.getViewport();
    	EditViewport.add(SourceTextArea);
   	    EditViewport.setBackingStoreEnabled(false);

    	JPanel       EditPanel = new JPanel();
    	EditPanel.setLayout(new BorderLayout());
    	EditPanel.add("Center", EditScrollPane);
    	EditContentPane.add("Center", EditPanel);
    }

    //*****************************************************************************
    /** We have been notified that the look-and-feel has changed.
     */
    public void updateUI()
    {
        super.updateUI();
	    setEditFont();
    }

    //*****************************************************************************
    /** Set the font used for editing. The size of the font is determined from that
     *  of the current metal user text font.
     */
    public void setEditFont()
    {
        Font  UserTextFont = MetalLookAndFeel.getUserTextFont();
        if (SourceTextArea != null)
	        SourceTextArea.setFont(new Font("Monospaced", Font.PLAIN, UserTextFont.getSize() ));
    }

    //*****************************************************************************
    /** Retrieve the text area in which the source is displayed and edited.
     *
     *  @return  The edit source text area
     */
    public JTextArea getSourceTextArea()
    {
	    return SourceTextArea;
    }

    //*****************************************************************************
    /** Retrieve an array of the actions supported by this type of edit area.
     *
     *  @return  An array of the actions supported by this class
     */
    static public Action[] getActions()
    {
        JTextArea  TempTextArea = new JTextArea();
	    return(TempTextArea.getActions() );
    }
}

//*****************************************************************************
