/*
** FILE:   xt_DocumentTreePanel.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    29Mar98  stevew  Created.
*/
package xt;

import xm.xm_DocumentModel;

import eh.eh_Debug;

import com.sun.java.swing.tree.DefaultTreeModel;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import com.sun.java.swing.event.TreeModelEvent;
import com.sun.java.swing.event.TreeModelListener;

import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTree;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.ToolTipManager;

import java.awt.BorderLayout;

//*****************************************************************************
/** xt_DocumentTreePanel is a JPanel containing a JTree which has knowledge of
 *  the xm_DocumentModel which it displays, and which can be notified of
 *  document change events relating to it.
 */
public class xt_DocumentTreePanel extends    JPanel
                                  implements TreeModelListener, DocumentListener
{
	/** The document currently being worked on. */
	xm_DocumentModel  TheDocumentModel = null;

    /** The tree which is to be displayed in this frame. */
    JTree             DocumentTree     = null;

    JScrollPane       TreeScrollPane   = null;

    //*****************************************************************************
    /** Constructor.
      */
    public xt_DocumentTreePanel(xm_DocumentModel  InputDocumentModel)
    {
//	    eh_Debug.add(7, "xt_DocumentTreePanel:");  //TEMP
        TheDocumentModel  = InputDocumentModel;
	    DefaultTreeModel  DocumentTreeModel = TheDocumentModel.getDocumentTreeModel();

        DocumentTree      = new JTree(DocumentTreeModel);

//	    TheDocumentModel.addDocumentListener(TheDocumentTree);  //TBD

	    // Enable tool tips for the tree nodes.
	    ToolTipManager.sharedInstance().registerComponent(DocumentTree);

	    // Make the tree use an instance of xt_TreeCellRenderer for drawing.
	    DocumentTree.setCellRenderer(new xt_TreeCellRenderer());
//        DocumentTree.setShowsRootHandles(true);

	    // Make the tree ask for the height of each row.
//	    DocumentTree.setRowHeight(-1);

        // Scroller.
    	TreeScrollPane          = new JScrollPane();
    	JViewport  TreeViewport = TreeScrollPane.getViewport();
    	TreeViewport.add(DocumentTree);

    	setLayout(new BorderLayout());
    	add("Center", TreeScrollPane);

    	DocumentTreeModel.addTreeModelListener(this);  // Let's be told of changes!
	    eh_Debug.add(7, "xt_DocumentTreePanel: Return");  //TEMP
    }

    //*****************************************************************************
    /** Stop listening to tree model changes.
     */
    public void removeTreeModelListener()
    {
	    DefaultTreeModel  DocumentTreeModel = TheDocumentModel.getDocumentTreeModel();
    	DocumentTreeModel.removeTreeModelListener(this);
    }

    //*****************************************************************************
    /** Get the tree scroll pane.
     *
     *  @return  The tree scroll pane
     */
    public JScrollPane getTreeScrollPane()
    {
        return TreeScrollPane;
    }


    //*****************************************************************************
    /** Get the document tree.
      */
    public JTree getTree()
    {
        return DocumentTree;
    }

    //*****************************************************************************
    //***Tree*model*listener*methods***********************************************
    //*****************************************************************************
    /** <p>Invoked after a node (or a set of siblings) has changed in some
     *  way. The node(s) have not changed locations in the tree or
     *  altered their children arrays, but other attributes have
     *  changed and may affect presentation. Example: the name of a
     *  file has changed, but it is in the same location in the file
     *  system.</p>
     *
     *  <p>e.path() returns the path the parent of the changed node(s).</p>
     *
     *  <p>e.childIndices() returns the index(es) of the changed node(s).</p>
     */
    public void treeNodesChanged(TreeModelEvent  InputTreeModelEvent)
    {
	    eh_Debug.add(5, "xt_DocumentTreePanel.treeNodesChanged:");
    }

    //*****************************************************************************
    /** <p>Invoked after nodes have been inserted into the tree.</p>
     *
     *  <p>e.path() returns the parent of the new nodes
     *  <p>e.childIndices() returns the indices of the new nodes in
     *  ascending order.
     */
    public void treeNodesInserted(TreeModelEvent  InputTreeModelEvent)
    {
	    eh_Debug.add(5, "xt_DocumentTreePanel.treeNodesInserted:");
    }

    //*****************************************************************************
    /** <p>Invoked after nodes have been removed from the tree.  Note that
     *  if a subtree is removed from the tree, this method may only be
     *  invoked once for the root of the removed subtree, not once for
     *  each individual set of siblings removed.</p>
     *
     *  <p>e.path() returns the former parent of the deleted nodes.</p>
     *
     *  <p>e.childIndices() returns the indices the nodes had before they were deleted in ascending order.</p>
     */
    public void treeNodesRemoved(TreeModelEvent  InputTreeModelEvent)
    {
	    eh_Debug.add(5, "xt_DocumentTreePanel.treeNodesRemoved:");
    }

    //*****************************************************************************
    /** <p>Invoked after the tree has drastically changed structure from a
     *  given node down.  If the path returned by e.getPath() is of length
     *  one and the first element does not identify the current root node
     *  the first element should become the new root of the tree.<p>
     *
     *  <p>e.path() holds the path to the node.</p>
     *  <p>e.childIndices() returns null.</p>
     */
    public void treeStructureChanged(TreeModelEvent  InputTreeModelEvent)
    {
	    eh_Debug.add(5, "xt_DocumentTreePanel.treeStructureChanged:");
    }

    //*****************************************************************************
    //***DocumentListener*methods**************************************************
    //*****************************************************************************
    /** Gives notification that there was an insert into the document. The given
     *  range bounds the freshly inserted region.
     *
     *  @param  InputDocumentEvent - the document event
     */
    public void insertUpdate(DocumentEvent  InputDocumentEvent)
    {
	    eh_Debug.add(5, "xt_DocumentTreePanel.insertUpdate: Tree has been told something has been inserted in document");
    }

    //*****************************************************************************
    /** Gives notification that a portion of the document has been removed. The
     *  range is given in terms of what the view last saw (that is, before updating
     *  sticky positions).
     *
     *  @param  InputDocumentEvent - the document event
     */
    public void removeUpdate(DocumentEvent  InputDocumentEvent)
    {
	    eh_Debug.add(5, "xt_DocumentTreePanel.removeUpdate: Tree has been told something has been removed from document");
    }

    //*****************************************************************************
    /** Gives notification that an attribute or set of attributes changed.
     *
     *  @param  InputDocumentEvent - the document event
     */
    public void changedUpdate(DocumentEvent  InputDocumentEvent)
    {
	    eh_Debug.add(5, "xt_DocumentTreePanel.changedUpdate: Tree has been told something has been changed in document");
    }
}

//*****************************************************************************
