/*
** FILE:   XT_DocumentTreeFrame.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    18Apr98  stevew  Created.
**    13Jun98  stevew  Split xt_DocumentTreeFrame.
**    14Jun98  stevew  Guts moved into xt_DocumentTreeSplitPane.
*/
package xt;

import xm.xm_DocumentModel;

import com.sun.java.swing.JInternalFrame;

import java.awt.BorderLayout;
import java.awt.Container;

//*****************************************************************************
/** xt_DocumentTreeFrame is a JPanel containing a JTree which has knowledge of
 *  the xm_DocumentModel which it displays, and which can be notified of
 *  document change events relating to it.
 */
public class xt_DocumentTreeFrame extends    xt_DocumentFrame
{
    /** Split pane which displays the tree view (DocumentTree) in its left side
     *  and the details of the currently-selected node () in its right side. */
    xt_DocumentTreeSplitPane  DocumentSplitPane     = null;

    //*****************************************************************************
    /** Constructor.
      */
    public xt_DocumentTreeFrame(xm_DocumentModel  InputDocumentModel,
                                String            InputFrameTitle)
    {
        super(InputDocumentModel, InputFrameTitle);
        DocumentSplitPane = new xt_DocumentTreeSplitPane(TheDocumentModel);

	    Container  TreeContentPane = getContentPane();
	    TreeContentPane.setLayout(new BorderLayout());
    	TreeContentPane.add("Center", DocumentSplitPane);
    }
}

//*****************************************************************************
