/*
** FILE:   xt_DocumentFrame.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    13Jun98  stevew  Created, split from xt_DocumentTreeFrame.
*/
package xt;

import xm.xm_DocumentModel;

import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JTextArea;

//*****************************************************************************
/** A base class for internal frames which display document-related information.
 */
public class xt_DocumentFrame extends JInternalFrame
{
	/** The document currently being worked on. */
	xm_DocumentModel      TheDocumentModel      = null;

    //*****************************************************************************
    /** Constructor.
      */
    public xt_DocumentFrame(xm_DocumentModel  InputDocumentModel,
                            String            InputFrameTitle)
    {
        super(InputFrameTitle);
        TheDocumentModel = InputDocumentModel;

        setResizable(true);
        setMaximizable(true);
        setIconifiable(true);
    }

    //*****************************************************************************
    /** Retrieve the document model associated with this frame. The purpose of this
     *  is to make convenient operations on whichever is the current frame. For
     *  example, a 'parse' toolbar button simply has to retrieve the document model
     *  of the current frame and perform a parse on it.
     *
     *  @return  The document model about which this frame displays information
     */
    public xm_DocumentModel getDocumentModel()
    {
	    return TheDocumentModel;
    }

    //*****************************************************************************
    /** Retrieve the text area in which the source is displayed and edited.
     *
     *  @return  The edit source text area
     */
    public JTextArea getSourceTextArea()
    {
        return null;
    }
}

//*****************************************************************************
