//*****************************************************************************
/*
** FILE:   xt_CheckBox.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    28May98  stevew  Created.
*/
package xt;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JCheckBox;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

//*****************************************************************************
/** A JCheckBox which keeps track of its own state. That is, it is so advanced
 *  that you can ask it whether it is checked or not (and it has to go to great
 *  lengths to do so).
 */
public class xt_CheckBox extends JCheckBox implements ItemListener
{
    /** Flag reflecting the current state (checked or not). It defaults to 'false'. */
    protected boolean  StateFlag = false;

    //*****************************************************************************
    /** Create an initially unselected checkbox button with no text, no icon.
     */
    public xt_CheckBox()
    {
 	    addItemListener(this);
    }

    //*****************************************************************************
    /** Create an initially unselected checkbox with an icon.
     *
     *  @param icon  the Icon image to display
     */
    public xt_CheckBox(Icon icon)
    {
        super(icon);
 	    addItemListener(this);
    }

    //*****************************************************************************
    /** Create a checkbox with an icon and specifies whether or not it is initially
     *  selected.
     *
     *  @param  icon      the Icon image to display
     *  @param  selected  a boolean value indicating the initial selection
     *                     state. If <code>true</code> the checkbox is selected
     */
    public xt_CheckBox(Icon icon, boolean selected)
    {
        super(icon, selected);
        StateFlag = selected;
 	    addItemListener(this);
    }

    //*****************************************************************************
    /** Create an initially unselected checkbox with text.
     *
     *  @param  text  the text of the checkbox.
     */
    public xt_CheckBox(String text)
    {
        super(text);
 	    addItemListener(this);
    }

    //*****************************************************************************
    /** Create a checkbox with text and specifies whether or not it is initially
     *  selected.
     *
     *  @param  text      the text of the checkbox.
     *  @param  selected  a boolean value indicating the initial selection
     *                     state. If <code>true</code> the checkbox is selected
     */
    public xt_CheckBox(String text, boolean selected)
    {
        super(text, selected);
        StateFlag = selected;
 	    addItemListener(this);
    }

    //*****************************************************************************
    /** Create an initially unselected checkbox with the specified text and icon.
     *
     *  @param  text  the text of the checkbox.
     *  @param  icon  the Icon image to display
     */
    public xt_CheckBox(String text, Icon icon)
    {
        super(text, icon);
 	    addItemListener(this);
    }

    //*****************************************************************************
    /** Create a checkbox with text and icon, and specifies whether or not it is
     *  initially selected.
     *
     *  @param  text     the text of the checkbox.
     *  @param  icon     the Icon image to display
     *  @param selected  a boolean value indicating the initial selection
     *                    state. If <code>true</code> the checkbox is selected
     */
    public xt_CheckBox(String text, Icon icon, boolean selected)
    {
        super(text, icon, selected);
        StateFlag = selected;
 	    addItemListener(this);
    }

    //*****************************************************************************
    /** Something's happened: determine the state of the check box.
     */
    public void itemStateChanged(ItemEvent  InputItemEvent)
    {
        int  StateChange = InputItemEvent.getStateChange();
        StateFlag = (StateChange == ItemEvent.SELECTED);
//        if (StateChange == ItemEvent.SELECTED)
//            StateFlag = true;
//        else
//            StateFlag = false;
    }

    //*****************************************************************************
    /** Set the current state of this check box.
     */
    public void setState(boolean  InputStateFlag)
    {
	    setSelected(InputStateFlag);
	    StateFlag = InputStateFlag;
    }

    //*****************************************************************************
    /** Get the current state (checked or not).
     */
    public boolean getState()
    {
	    return StateFlag;
    }
}

//*****************************************************************************
