//*****************************************************************************
/*
** FILE:   xs_StylesheetDefn.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    18Jun98  stevew  Created.
*/
package xs;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.util.Hashtable;
import java.util.Vector;

//*****************************************************************************
/** The pre-processed definition of an XSL stylesheet. It exists mainly
 *  for convenience, to allow the pieces to be easily passed around - and
 *  without the circular dependencies and unecessary baggage that passing a
 *  full XML element object would.
 */
public class xs_StylesheetDefn
{
    /** Vector of the rules defined in this stylesheet. */
    protected Vector           RuleVector            = null;

    /** Vector of the style rules defined in this stylesheet. */
    protected Vector           StyleRuleVector       = null;

    /** Hashtable of the defined styles. */
    protected Hashtable        DefinedStyleHashtable = new Hashtable();

    //*****************************************************************************
    /** Default constructor.
     */
    public xs_StylesheetDefn()
    {
    }

    //*****************************************************************************
    /** Construct an XSL stylesheet definition with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
//    public xs_StylesheetDefn(String InputNodeName)
//    {
//    }

    //*****************************************************************************
    /** Set the vector of the defined rules.
     *
     *  @param  InputRuleVector  The vector of rules
     */
    public void setRules(Vector  InputRuleVector)
    {
        RuleVector = InputRuleVector;
    }

    //*****************************************************************************
    /** Set the vector of the defined style rules.
     *
     *  @return  The vector of style rules
     */
    public void setStyleRules(Vector  InputStyleRuleVector)
    {
        StyleRuleVector = InputStyleRuleVector;
    }

    //*****************************************************************************
    /** Add an element to the hash table of defined styles.
     *
     *  @param      InputDefinedStyle         A define-style element to add
     *  @exception  xg_VerificationException  Either the InputDefinedStyle contains
     *                                         no 'name' attribute or a define-style
     *                                         with this name is already present
     */
    public void addDefinedStyle(xg_Element  InputDefinedStyle)
                                                   throws xg_VerificationException
    {
        String  DefinedStyleName = InputDefinedStyle.getAttributeValue("name");  //TEMP hardcoding
        if (DefinedStyleName == null)
            throw new xg_VerificationException("define-style element contains no 'name' attribute",
                                               InputDefinedStyle.getStartOffset(),
                                               InputDefinedStyle.getEndOffset() );

        if (DefinedStyleHashtable.contains(DefinedStyleName) )
            throw new xg_VerificationException("There is already a define-style element whose 'name' attribute is '"
                                                  + DefinedStyleName + "'",
                                               InputDefinedStyle.getStartOffset(),
                                               InputDefinedStyle.getEndOffset() );

        DefinedStyleHashtable.put(DefinedStyleName, InputDefinedStyle);
    }

    //*****************************************************************************
    /** Get the vector of the defined rules.
     *
     *  @return  The vector of rules
     */
    public Vector getRules()
    {
        return RuleVector;
    }

    //*****************************************************************************
    /** Get the vector of the defined style rules.
     *
     *  @return  The vector of style rules
     */
    public Vector getStyleRules()
    {
        return StyleRuleVector;
    }

    //*****************************************************************************
    /** Get the hashtable of defined styles.
     *
     *  @return  The hashtable of defined styles
     */
    public Hashtable getDefinedStyles()
    {
        return DefinedStyleHashtable;
    }
}

//*****************************************************************************
