//*****************************************************************************
/*
** FILE:   xs_StyleThread.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    06Aug98  stevew  Created, based on xm_FileLoader.
*/
package xs;

import xm.xm_StatusBar;
import xm.xm_Thread;

import xg.xg_Document;

import eh.eh_Debug;

import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;

import java.awt.Container;

import java.io.IOException;
import java.io.StringWriter;

//*****************************************************************************
/** Thread to apply XSL style to an XML document.
 */
public class xs_StyleThread extends xm_Thread
{
    /** The XSL stylesheet to use. */
    xg_Document   Stylesheet;

    /** The XML document to which we wish to apply style. */
    xg_Document   SourceDocument;

    /** The document into which to place the results of applying the stylesheet. */
    Document      ResultsDocument;

    //*****************************************************************************
    /** Constructor.
     */
    public xs_StyleThread(xg_Document   InputStylesheet,
                          xg_Document   InputSourceDocument,
                          Document      OutputResultsDocument,
                          xm_StatusBar  InputStatusBar)
    {
        super(InputStatusBar);
    	SourceDocument  = InputSourceDocument;
    	Stylesheet      = InputStylesheet;
    	ResultsDocument = OutputResultsDocument;
    }

    //*****************************************************************************
    public void run()
    {
        try
        {
    	    sleep(50);   // Avoid deadlock with focus setting code
            long  StartTime = System.currentTimeMillis();

    	    // Initialize the progress bar.
            JProgressBar  StyleProgressBar = prepareProgressBar(SourceDocument.getEndOffset(),
                                                                9,
                                                                "Applying stylesheet ...");

	        xs_XslEngine  XslEngine           = new xs_XslEngine();
            StringWriter  ResultsStringWriter = new StringWriter();

  	        // Clear the previous results.
   	        ResultsDocument.remove(ResultsDocument.getStartPosition().getOffset(),
   	                               ResultsDocument.getLength() );

            XslEngine.applyStyle(Stylesheet,
                                 SourceDocument,
                                 ResultsStringWriter,
                                 StyleProgressBar);

            ResultsDocument.insertString(0, ResultsStringWriter.toString(), null);
    	    removeProgressBar(9, "Completed applying stylesheet: "
                                      + getStyleStatsText(StartTime) );
        }
        catch (xs_StyleException  InputException)
        {
        	removeProgressBar(2, "Error applying stylesheet: "
                                       + InputException.getMessage() );
            eh_Debug.printStackTrace(2, InputException);
        }
        catch (Exception  InputException)
        {
        	removeProgressBar(2, "Error applying stylesheet: " + InputException);
            eh_Debug.printStackTrace(2, InputException);
        }
    }

    //*****************************************************************************
    /** Prepare and return a string describing how much was styled, and how fast.
     *
     *  This method is private because it uses the current time as the time at which
     *  the style is deemed to have completed - so if called from outside later,
     *  a misleading result will be given.
     *
     *  @param  InputStyleStartTime  The system time at which the style started
     *  @return                      A string description of the style statistics
     */
    protected String getStyleStatsText(long  InputStyleStartTime)
    {
        long    StyleTimeMillis = System.currentTimeMillis() - InputStyleStartTime;
        float   StyleTime       = ((float)StyleTimeMillis) / 1000;
        float   StyleInputRate  = SourceDocument.getEndOffset() / StyleTime;
        float   StyleOutputRate = ResultsDocument.getLength() / StyleTime;
        String  StyleStatsText  = new String(SourceDocument.getEndOffset()
                                             + " characters input (" + StyleInputRate
                                             + " per second), "
                                             + ResultsDocument.getLength()
                                             + " output (" + StyleOutputRate
                                             + " per second) in "
                                             + StyleTime + " seconds");
        return StyleStatsText;
    }
}

//*****************************************************************************
