//*****************************************************************************
/*
** FILE:   xs_StyleException.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    15Jun98  stevew  Created.
*/
package xs;

import java.io.IOException;

//*****************************************************************************
/**
*  Class xs_StyleException - Exception when an error occurs while applying
*  an XSL stylesheet to an XML document.
*/
public class xs_StyleException extends IOException
{
    /** The position in the source at which the last significant item occurred
     *  (which is typically the start of the node currently being parsed) when the
      * exception occurred. */
    private int  LastSignificantPosition = 0;

    /** The position in the source (number of characters) when the exception
     *  occurred. */
    private int  ParsePosition           = 0;

    //*****************************************************************************
    /**
     * Constructor.
     *
     * @param  InputDescription  Description of exception
     * @param  InputLastSignificantPosition  The position of the last significant
     *                                        event
     * @param  InputParsePosition  The current character position in the source
     */
    public xs_StyleException(String InputDescription,
                             int    InputLastSignificantPosition,
                             int    InputParsePosition)
    {
        super(InputDescription);
        LastSignificantPosition = InputLastSignificantPosition;
        ParsePosition           = InputParsePosition;
    }

    //*****************************************************************************
    /**
     * Constructor.
     *
     * @param  InputDescription  Description of exception
     */
    public xs_StyleException(String InputDescription)
    {
        super(InputDescription);
    }

    //*****************************************************************************
    /**
     *  Get the position in the source at which the last significant item occurred.
     *
     * @return  The position in the source of the last significant event
     */
    public int getLastSignificantPosition()
    {
        return LastSignificantPosition;
    }

    //*****************************************************************************
    /**
     *  Get the position in the source (number of characters) when the exception
     *  occurred.
     *
     * @return  The source position at which the exception occurred
     */
    public int getParsePosition()
    {
        return ParsePosition;
    }

    //*****************************************************************************
    /**
     *  Get a string representation of this exception.
     *
     * @return  A string representation of this exception
     */
/*    public String toString()
    {
        String  ExceptionString = new String("xe.xs_StyleException at positions "
                                               + LastSignificantPosition + "-"
                                               + ParsePosition);
        return ExceptionString;
    }
*/

    //*****************************************************************************
    /**
     *  Get a string representation of this exception.
     *
     * @return  A string representation of this exception
     */
    public String getMessage2()
    {
        String  ExceptionString = new String("xe.xs_StyleException at positions "
                                               + LastSignificantPosition + "-"
                                               + ParsePosition);
        return ExceptionString;
    }
}

//*****************************************************************************
