//*****************************************************************************
/*
** FILE:   xs_StyleAttList.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    12Jul98  stevew  Created, based on xg_AttList.
*/
package xs;

import xg.xg_AttList;
import xg.xg_Attribute;

//*****************************************************************************
/** An XML attribute list to be used for XSL style attributes. It has the
 *  ability to return all of its contents in the form of a single attribute
 *  suitable for output as CSS. This class was written for convenience only,
 *  and it is not expected that any types of elements will use it to hold their
 *  attribute lists (instead of a plain xg_AttList).
 */
public class xs_StyleAttList extends xg_AttList
{
    /** The name of the attribute normally used for the net result of a number
     *  of style attributes. */
    public final static String StyleAttName = "style";

    //*****************************************************************************
    /** Default constructor.
     */
    public xs_StyleAttList()
    {
    }

    //*****************************************************************************
    /** <p>Return a single 'style' attribute generated from all the attributes
     *  herein. This 'style' attribute is not actually a member of this attribute
     *  list.</p>
     *
     *  <p>An attribute list with attributes: n1="v1", n2="v2", etc. will be
     *  returned as one attribute of the form: style="n1:v1; n2:v2; ...".</p>
     *
     *  @return  A composite CSS-format style attribute produced from all the
     *            attributes in this list
     */
    public xg_Attribute  getStyleAtt()
    {
        return (new xg_Attribute(StyleAttName, getStyleAttValue() ) );
    }

    //*****************************************************************************
    /** <p>Return the value of a single 'style' attribute generated from all the
     *  attributes herein.</p>
     *
     *  <p>An attribute list with attributes: n1="v1", n2="v2", etc. will be
     *  returned as one value of the form: "n1:v1; n2:v2; ...".</p>
     *
     *  @return  A composite CSS-format style attribute value produced from all the
     *            attributes in this list
     */
    public String  getStyleAttValue()
    {
        // Duplicate each attribute (if there are any).
        StringBuffer  StyleAttValue = new StringBuffer();
        xg_Attribute  CurrentAtt    = null;
        for (int AttIndex = 0; AttIndex < AttributeVector.size(); AttIndex++)
        {
            CurrentAtt = getAtt(AttIndex);
            if (AttIndex > 0)
                StyleAttValue.append("; ");
            StyleAttValue.append(CurrentAtt.getName() + ":" + CurrentAtt.getValue() );
        }

        return(StyleAttValue.toString() );
    }
}

//*****************************************************************************
