/*
** FILE:   xs_PatternElementCustomizer.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    21Jun98  stevew  Created, based on xc_ElementCustomizer.
*/
package xs;

import xc.xc_ElementCustomizer;

import xg.xg_Element;
import xg.xg_Node;

import eh.eh_Debug;

import com.sun.java.swing.table.AbstractTableModel;
import com.sun.java.swing.table.TableModel;

import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;

import java.awt.BorderLayout;
import java.awt.Color;

//*****************************************************************************
/**
 * xs_PatternElementCustomizer is an element customizer for editing an
 * xs_PatternElement.
 */
public class xs_PatternElementCustomizer extends xc_ElementCustomizer
{
	/** The pattern element currently being displayed. */
	xs_PatternElement     CurrentPatternElement     = null;

    // Attributes relating to the display of the pattern's match level.
    /** Panel for the display of the pattern's match level details. */
    JPanel                MatchLevelPanel           = null;

    /** Table displaying the pattern's match level details. */
    JTable                MatchLevelTable           = null;

    /** Model of the attribute data for display in the MatchLevelTable. */
    MatchLevelTableModel  TheMatchLevelTableModel   = null;

    /** Scroller for the table of match level details. */
    JScrollPane           MatchLevelTableScrollPane = null;

    //*****************************************************************************
    /**
     * Default constructor.
     */
    public xs_PatternElementCustomizer()
    {
    }

    //*****************************************************************************
    /**
     * Add all required tabs.
     */
    public void addTabs()
    {
        super.addTabs();
        addMatchLevelTab();
    }

    //*****************************************************************************
    /**
     * Add 'Match level' tab to display the pattern's match level details.
     */
    public void addMatchLevelTab()
    {
        MatchLevelPanel = new JPanel();
        EditTabbedPane.addTab("Match level", MatchLevelPanel);

	    MatchLevelPanel.setLayout(new BorderLayout());

        // Set up table for the match level details.
        TheMatchLevelTableModel   = new MatchLevelTableModel();
        MatchLevelTable           = new JTable(TheMatchLevelTableModel);
        MatchLevelTable.setBackground(Color.lightGray);
        MatchLevelTableScrollPane = new JScrollPane(MatchLevelTable);
        MatchLevelPanel.add(MatchLevelTableScrollPane, BorderLayout.CENTER);
    }

    //*****************************************************************************
    /**
     * Set the node to edit.
     *
     * @param  InputNode  The node to edit
     */
    public void setNode(xg_Node  InputNode)
    {
        super.setNode(InputNode);
        CurrentPatternElement = (xs_PatternElement)InputNode;
    }

    //*****************************************************************************
    /**
     * Get the match level scroll pane.
     *
     * @return  The match level scroll pane
     */
/*    public JScrollPane getMatchLevelTableScrollPane()
    {
        return MatchLevelTableScrollPane;
    }
*/
    //*****************************************************************************
    /**
     * Inner class to provide a model for the match level details for use in the
     * table display.
     */
    class MatchLevelTableModel extends AbstractTableModel
    {
        //*****************************************************************************
        public int getColumnCount()
        {
            return 2;
        }

        //*****************************************************************************
        public int getRowCount()
        {
            return 11;
        }

        //*****************************************************************************
        public Object getValueAt(int InputRowNum, int InputColumnNum)
        {
            Object  ValueObject = null;

            switch (InputColumnNum)
            {
                case 0:
                    ValueObject = getLabelValueAt(InputRowNum);
                    break;

                case 1:
                    ValueObject = getValueValueAt(InputRowNum);
                    break;

                default:
	                eh_Debug.add(5, "xc_NodeCustomizer.getValueAt: Invalid column number ("
	                                     + InputColumnNum + ") requested");
            }

            return ValueObject;
        }

        //*****************************************************************************
        /**
         * Get the value of the label for the given row (implicitly column 0).
         *
         * @param  InputRowNum  the number of the row whose label is required
         */
        public Object getLabelValueAt(int InputRowNum)
        {
            Object  ValueObject = null;

            switch (InputRowNum)
            {
            case 0:
                ValueObject = new String("Overall match level");
                break;

            case 1:
                ValueObject = new String("Is overall match level valid?");
                break;

            case 2:
                ValueObject = new String("1. Rule importance");
                break;

            case 3:
                ValueObject = new String("2. Number of 'id' attributes");
                break;

            case 4:
                ValueObject = new String("3. Number of 'class' attributes");
                break;

            case 5:
                ValueObject = new String("4. Number of 'type' attributes");
                break;

            case 6:
                ValueObject = new String("5. Number of wildcards");
                break;

            case 7:
                ValueObject = new String("6. Rule priority");
                break;

            case 8:
                ValueObject = new String("7. Number of 'only' qualifiers");
                break;

            case 9:
                ValueObject = new String("8. Number of position qualifiers");
                break;

            case 10:
                ValueObject = new String("9. Number of attribute specifications");
                break;

            default:
	            eh_Debug.add(2, "xc_NodeCustomizer.getLabelValueAt: Invalid row number ("
	                                 + InputRowNum + ") requested");
                ValueObject = new String("*Unknown*");
            }

            return ValueObject;
        }

        //*****************************************************************************
        /**
         * Get the value for the given row (implicitly column 1).
         *
         * @param  InputRowNum  the number of the row whose value is required
         */
        public Object getValueValueAt(int InputRowNum)
        {
            Object  ValueObject = null;

            if (CurrentPatternElement == null)
                ValueObject = new String("***");
            else
            {
                xs_PatternMatchLevel  MatchLevel = CurrentPatternElement.getMatchLevel();
                switch (InputRowNum)
                {
                case 0:
                    ValueObject = new Long(MatchLevel.getOverallMatchLevel());
                    break;

                case 1:
                    ValueObject = new Boolean(MatchLevel.isOverallMatchLevelValid());
                    break;

                case 2:
                    ValueObject = new Integer(MatchLevel.getRuleImportanceLevel());
                    break;

                case 3:
                    ValueObject = new Integer(MatchLevel.getIdCount() );
                    break;

                case 4:
                    ValueObject = new Integer(MatchLevel.getClassCount());
                    break;

                case 5:
                    ValueObject = new Integer(MatchLevel.getTypeElementCount());
                    break;

                case 6:
                    ValueObject = new Integer(MatchLevel.getWildcardCount());
                    break;

                case 7:
                    ValueObject = new Integer(MatchLevel.getRulePriorityLevel());
                    break;

                case 8:
                    ValueObject = new Integer(MatchLevel.getOnlyCount());
                    break;

                case 9:
                    ValueObject = new Integer(MatchLevel.getPositionCount());
                    break;

                case 10:
                    ValueObject = new Integer(MatchLevel.getAttSpecCount());
                    break;

                default:
	                eh_Debug.add(2, "xc_NodeCustomizer.getValueValueAt: Invalid row number ("
	                                              + InputRowNum + ") requested");
                    ValueObject = new String("*Unknown*");
                }
            }

            return ValueObject;
        }

        //*****************************************************************************
        /**
         * Get the name for the given column.
         *
         * @param  InputColumnNum  the number of the column whose name is required
         */
        public String getColumnName(int InputColumnNum)
        {
            String  ColumnName = null;

            switch (InputColumnNum)
            {
                case 0:
                    ColumnName = new String("Name");
                    break;

                case 1:
                    ColumnName = new String("Value");
                    break;

                default:
                    ColumnName = new String("*Unknown*");
	                eh_Debug.add(5, "xs_PatternElementCustomizer.getColumnName: Invalid column number ("
	                                     + InputColumnNum + ") requested");
            }

            return ColumnName;
        }

        //*****************************************************************************
//        public Class getColumnClass(int  InputColumnNum)
//        {
//            return getValueAt(0, InputColumnNum).getClass();
//        }

        //*****************************************************************************
        public boolean isCellEditable(int InputRowNum, int InputColumnNum)
        {
            return false;
        }

        //*****************************************************************************
/*        public void setValueAt(Object InputValueObject, int InputRowNum, int InputColumnNum)
        {
	        eh_Debug.add(5, "xs_PatternElementCustomizer.setValueAt: Set row "
	                              + InputRowNum + ", column "
	                              + InputColumnNum + " to " + InputValueObject.toString() );
        }
*/
    }
}

//*****************************************************************************
