//*****************************************************************************
/*
** FILE:   xs_EvalElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24Jun98  stevew  Created.
*/
package xs;

import xg.xg_Element;
import xg.xg_Node;

import eh.eh_Debug;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/** An XML element representing an 'eval' action within an XSL rule.
*/
public class xs_EvalElement extends xs_ActionElement
{
    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "eval";

    //*****************************************************************************
    /** Construct an eval element with no name.
     */
    public xs_EvalElement()
    {
    }

    //*****************************************************************************
    /** Construct an eval element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xs_EvalElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** Invoke this action to the InputSourceElement, and write the results to the
     *  InputResultsWriter.
     *
     * @param      InputSourceElement   The pre-parsed source element currently being
     *                                   processed
     * @param      InputResultsWriter   The writer to which to write the results of
     *                                   applying a stylesheet to the source element
     * @exception  xs_StyleException    Error applying style
     * @exception  IOException          Error writing to results writer
     */
    public void invoke(xg_Element  InputSourceElement,
                       Writer      InputResultsWriter)
                          throws xs_StyleException, IOException
    {
//        eh_Debug.add(6, "xs_EvalElement.invoke: evaluate script for source "
//                             + InputSourceElement);
        eh_Debug.add(3, "xs_EvalElement.invoke: <eval> processing not supported");

        saveContent(InputResultsWriter);  //TEMP
    }

    //*****************************************************************************
    /**
     * Get a summary descriptive string suitable for display in the tree view or
     * elsewhere.
     *
     * @return  A description suitable for display in the tree view
     */
/*    public String toString()
    {
        return ("XSL eval action");
    }
*/
}

//*****************************************************************************
