//*****************************************************************************
/*
** FILE:   xs_EmptyElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    28Jun98  stevew  Created.
*/
package xs;

//*****************************************************************************
/** An XML element representing an 'empty' action within an XSL rule. It is
 *  used to deliberately signify that no output is be generated when it is
 *  invoked - and miraculously achieves this by being an almost empty class
 *  itself!
 */
public class xs_EmptyElement extends xs_ActionElement
{
    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "empty";

    //*****************************************************************************
    /** Construct an 'empty' element with no name.
     */
    public xs_EmptyElement()
    {
    }

    //*****************************************************************************
    /** Construct an 'empty' element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xs_EmptyElement(String InputNodeName)
    {
        super(InputNodeName);
    }
}

//*****************************************************************************
