//*****************************************************************************
/*
** FILE:   xs_ActionElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    18Jun98  stevew  Created.
*/
package xs;

import xg.xg_Element;

import com.sun.java.swing.JProgressBar;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/** An XML element representing an action within an XSL rule.
 */
public class xs_ActionElement extends xg_Element
{
    /** The definition of the stylesheet which is currently being applied. */
    protected xs_StylesheetDefn  TheStylesheetDefn = null;

    /** Progress bar for application of style. */
    protected JProgressBar       StyleProgressBar  = null;

    //*****************************************************************************
    /** Construct an action element with no name.
     */
    public xs_ActionElement()
    {
    }

    //*****************************************************************************
    /** Construct an action element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public xs_ActionElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** Invoke this action to the InputSourceElement. This is expected to be
     *  overridden in derived classes, to write suitable output to the
     *  InputResultsWriter; this implementation does nothing.
     *
     *  @param      InputSourceElement   The pre-parsed source document
     *  @param      InputResultsWriter   The writer to which to write the results of
     *                                    applying a stylesheet to the source element
     *  @exception  xs_StyleException    Error applying style
     *  @exception  IOException          Error writing to results writer
     */
    public void invoke(xg_Element  InputSourceElement,
                       Writer      InputResultsWriter)
                          throws xs_StyleException, IOException
    {
    }

    //*****************************************************************************
    /** Set the stylesheet definition currently being applied. The purpose of this
     *  is to enable derived classes to create xs_Stylist objects to perform
     *  further work (although note that the xs_ActionElement class itself has no
     *  knowledge of xs_Stylist, to avoid a circular dependency).
     *
     *  @param  InputStylesheetDefn  The definition of the stylesheet to apply
     */
    public void setStylesheetDefn(xs_StylesheetDefn  InputStylesheetDefn)
    {
        TheStylesheetDefn = InputStylesheetDefn;
    }

    //*****************************************************************************
    /** Set the bar on which to show progress (as measured by the end offset of
     *  each node after it is processed).
     *
     *  @param  InputProgressBar  Progress bar for application of style
     */
    public void setProgressBar(JProgressBar  InputProgressBar)
    {
        StyleProgressBar = InputProgressBar;
    }

    //*****************************************************************************
    /** Return a string representation of the element (intended for use as debug
     *  output).
     *
     *  @return  String representing the node name and its type.
     */
    public String toString()
    {
        return ("XSL '" + NodeName + "' action");
    }
}

//*****************************************************************************
