//*****************************************************************************
/*
** FILE:   xm_Thread.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    14Jul98  stevew  Created, split from xm_ParseThread.
*/
package xm;

import eh.eh_Debug;

import com.sun.java.swing.JProgressBar;

import java.awt.Container;

//*****************************************************************************
/** Thread with support for displaying messages and indicating progress in a
 *  status bar.
 */
public class xm_Thread extends Thread
{
    /** Status bar to reflect the progress of the work of the thread. */
    xm_StatusBar      TheStatusBar;

    //*****************************************************************************
    /** Constructor.
     *
     *  @param InputStatusBar  Status bar in which to display messages and show
     *                          progress
     */
    public xm_Thread(xm_StatusBar  InputStatusBar)
    {
    	setPriority(4);
    	TheStatusBar = InputStatusBar;
    }

    //*****************************************************************************
    /** Run the thread - to be overridden in derived classes.
     */
    public void run()
    {
    }

    //*****************************************************************************
    /** Add a progress bar to the status bar (if there is a status bar), and
     *  display a message on the status bar.
     *
     *  @param  InputProgressBarMaximum  The maximum value the progress bar will
     *                                    reach
     *  @param  InputMessageDebugLevel   The message is also output to debug with
     *                                    this debug level
     *  @param  InputStatusBarMessage    A message to be displayed in the status bar
     */
    protected JProgressBar prepareProgressBar(int     InputProgressBarMaximum,
                                              int     InputMessageDebugLevel,
                                              String  InputStatusBarMessage)
    {
   	    JProgressBar  TheProgressBar = null;
        if (TheStatusBar == null)
        {
    	    if (InputStatusBarMessage != null)
                eh_Debug.add(InputMessageDebugLevel, InputStatusBarMessage);
        }
        else
        {
   	        TheProgressBar = TheStatusBar.addProgressBar();
   	        TheProgressBar.setMinimum(0);
   	        TheProgressBar.setMaximum(InputProgressBarMaximum);
            TheStatusBar.setText(InputMessageDebugLevel, InputStatusBarMessage);
   	        validateContainerHierarchy();
        }

        return TheProgressBar;
    }

    //*****************************************************************************
    /** Remove the progress bar from the status bar (if there is a status bar),
     *  display the InputStatusBarMessage on the status bar, and output this
     *  message to debug if the current debug level is at least as high as
     *  InputMessageDebugLevel.
     *
     *  @param  InputMessageDebugLevel  The message is also output to debug with
     *                                   this debug level
     *  @param  InputStatusBarMessage   A message to be displayed in the status bar
     */
    protected void removeProgressBar(int     InputMessageDebugLevel,
                                     String  InputStatusBarMessage)
    {
        if (TheStatusBar == null)
        {
    	    if (InputStatusBarMessage != null)
                eh_Debug.add(InputMessageDebugLevel, InputStatusBarMessage);
        }
        else
        {
    	    TheStatusBar.removeProgressBar();

    	    if (InputStatusBarMessage != null)
    	        TheStatusBar.setText(InputMessageDebugLevel, InputStatusBarMessage);

            validateContainerHierarchy();
        }
    }

    //*****************************************************************************
    /** Remove the progress bar from the status bar (if there is a status bar).
     */
    protected void removeProgressBar()
    {
        if (TheStatusBar != null)
        {
    	    TheStatusBar.removeProgressBar();
            validateContainerHierarchy();
        }
    }

    //*****************************************************************************
    /** Set the text on the status bar (if there is a status bar).
     *
     *  @param  InputMessageDebugLevel  The message is also output to debug with
     *                                   this debug level
     *  @param  InputStatusBarMessage   A message to be displayed in the status bar
     */
    protected void setStatusBarText(int     InputMessageDebugLevel,
                                    String  InputStatusBarMessage)
    {
        if (TheStatusBar != null)
   	        TheStatusBar.setText(InputMessageDebugLevel, InputStatusBarMessage);
    }

    //*****************************************************************************
    /** Validate from the top of the containment hierarchy.
     */
    public void validateContainerHierarchy()
    {
        if (TheStatusBar != null)
        {
    	    synchronized (TheStatusBar.getTreeLock())
    	    {
    	        Container CurrentContainer = TheStatusBar;
    	        for (Container ParentContainer = TheStatusBar.getParent();
    	             ParentContainer != null && ! ParentContainer.isValid();
        		     ParentContainer = ParentContainer.getParent())
                {
        		    CurrentContainer = ParentContainer;
    	        }
    	        CurrentContainer.validate();
    	    }
    	}
    }
}

//*****************************************************************************
