//*****************************************************************************
/*
** FILE:   xm_StatusBar.java
**
** (c) 1997, 1998 Steve Withall.
**
** HISTORY:
**    01Apr98  stevew  Created.
**    03Jul98  stevew  Moved from xt to xm.
*/
package xm;

import eh.eh_Debug;

import com.sun.java.swing.border.Border;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.JTextField;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;

//*****************************************************************************
/** Status bar for the display of general application messages.
 */
public class xm_StatusBar extends JPanel
{
    /** The area in which the main status text is displayed. */
    JTextField    StatusText        = new JTextField();

    /** If this status bar is called upon to display the progress of some
     *  activity, it is displayed here. */
  	JProgressBar  StatusProgressBar = new JProgressBar();

    /** The border used for normal components which have a border. */
    Border        StandardBorder    = null;

    //*****************************************************************************
    /** Constructor.
     */
    public xm_StatusBar()
    {
	    super();

        StandardBorder = BorderFactory.createEtchedBorder();
        setBorder(StandardBorder);

   	    setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

        StatusText.setEditable(false);
        StatusText.setBorder(StandardBorder);
        StatusText.setForeground(Color.black);
        StatusText.setBackground(Color.lightGray);
        StatusText.setFont(new Font("SansSerif", Font.PLAIN, 12));
        add(StatusText);
   	}

    //*****************************************************************************
    /** Set the text in the status bar. Also output it to debug, using a default
     *  debug level of 5.
     *
     *  @param  InputText  The text to be displayed on the status bar
     */
    public void setText(String  InputText)
    {
        setText(5, InputText);
   	}

    //*****************************************************************************
    /** Set the text in the status bar. Also output to debug with the specified
     *  debug level.
     *
     *  @param  InputDebugLevel  The debug level with which to output this text to
     *                            debug
     *  @param  InputText        The text to be displayed on the status bar
     */
    public void setText(int  InputDebugLevel, String  InputText)
    {
        eh_Debug.add(InputDebugLevel, InputText);
        StatusText.setText(InputText);
        repaint(50);
   	}

    //*****************************************************************************
    /** Add the progress bar to the status bar.
     *
     *  @returns  The progress bar
     */
    public JProgressBar addProgressBar()
    {
        StatusProgressBar.setValue(0);
    	add(StatusProgressBar);
    	return(StatusProgressBar);
   	}

    //*****************************************************************************
    /** Remove the progress bar from the status bar.
     */
    public void removeProgressBar()
    {
    	remove(StatusProgressBar);
   	}

    //*****************************************************************************
    /** Get the progress bar.
     *
     *  @returns  The progress bar
     */
    public JProgressBar getProgressBar()
    {
    	return(StatusProgressBar);
   	}

    //*****************************************************************************
    /** Validate from the top of the containment hierarchy.
     */
    public void validateContainerHierarchy()
    {
    	Container CurrentContainer = this;
    	for (Container ParentContainer = getParent();
    	     ParentContainer != null && ! ParentContainer.isValid();
             ParentContainer = ParentContainer.getParent())
        {
        	CurrentContainer = ParentContainer;
    	}
    	CurrentContainer.validate();
    }
}

//*****************************************************************************
