//*****************************************************************************
/*
** FILE:   xm_ParseListener.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    06Apr98  stevew  Created.
**    03Jul98  stevew  Moved from xe to xm.
*/
package xm;

import xg.xg_Node;

import java.lang.Exception;

//*****************************************************************************
/** <p>Listener interface for the notification of events which occur during
 *  the processing of an XML source. Its main purpose is to facilitate
 *  observation of the progress of the parse (eg. by displaying it in a progress
 *  bar), rather than for the triggering of serious processing (which is what
 *  SAX does); any such processing should be done by the xg-derived nodes
 *  which are created in any case.</p>
 *
 *  <p>It is similar in certain respects to the SAX DocumentHandler interface,
 *  although it is invoked at a somewhat different level in the parse process.
 *  SAX is a low-level parse driver and invokes DocumentHandler when content
 *  needs to be process, whereas xm_ParseListener is invoked after the fact,
 *  assuming that xm has handled all the main processing.</p>
 *
 *  <p>References to SAX relate to the 12Jan98 version of the SAX specification.</p>
 */
public interface xm_ParseListener
{
    //*****************************************************************************
    /** The start of a node has been parsed.
     *
     *  startNode() can be equated to a higher-level version of the SAX method
     *  startElement().
     *
     *  @param  InputNode           The node whose start has just been parsed
     *  @param  InputStartPosition  The offset from the start of the source at
     *                               which this node starts
     */
    public abstract void startNode(xg_Node  InputNewNode,
                                   int      InputStartPosition);

    //*****************************************************************************
    /** The end of a node has been parsed.
     *
     *  EndNode can be equated to a rich version of the SAX method endElement().
     *
     *  @param  InputNewNode      The node which has just been parsed
     *  @param  InputEndPosition  The offset from the start of the source at
     *                             which this node ends
     */
    public abstract void endNode(xg_Node  InputNewNode,
                                 int      InputEndPosition);

    //*****************************************************************************
    /** The parse has completed successfully.
     *
     *  EndParseSuccessful can be equated to the SAX method endDocument().
     */
    public abstract void endParseSuccessful();

    //*****************************************************************************
    /** The parse has completed, but not successfully.
     */
    public abstract void endParseUnsuccessful();

    //*****************************************************************************
    //*****************************************************************************
    //*****************************************************************************
    // The remainder of this source comprises the methods from the SAX
    // DocumentHandler interface, for reference purposes.

  /**
    * Handle the start of a document.
    * <p>This is the first event called by a
    * SAX-conformant parser, so you can use it to allocate and
    * initialise new objects for the document.</p>
    * @exception java.lang.Exception You may throw any exception.
    */
/*  public void startDocument ()
    throws Exception;
*/

    //*****************************************************************************
  /**
    * Handle the document type declaration.
    * <p>This will appear only if the XML document contains a
    * <code>DOCTYPE</code> declaration.</p>
    * @param name The document type name.
    * @param publicID The public identifier of the external DTD subset
    *                 (if any), or null.
    * @param systemID The system identifier of the external DTD subset
    *                 (if any), or null.
    * @param name The document type name.
    * @exception java.lang.Exception You may throw any exception.
    */
/*  public void doctype (String name, String publicID, String systemID)
    throws Exception;
*/

    //*****************************************************************************
  /**
    * Handle significant character data.
    * @param ch An array of characters.
    * @param start The starting position in the array.
    * @param length The number of characters to use in the array.
    * @exception java.lang.Exception You may throw any exception.
    */
/*  public void characters (char ch[], int start, int length)
    throws Exception;
*/

    //*****************************************************************************
  /**
    * Handle ignorable whitespace.
    * @param ch An array of whitespace characters.
    * @param start The starting position in the array.
    * @param length The number of characters to use in the array.
    * @exception java.lang.Exception You may throw any exception.
    */
/*  public void ignorable (char ch[], int start, int length)
    throws Exception;
*/

    //*****************************************************************************
  /**
    * Handle a processing instruction.
    * <p>XML processing instructions have two parts: a target, which
    * is a name, followed optionally by data.</p>
    * @exception java.lang.Exception You may throw any exception.
    */
/*  public void processingInstruction (String name, String remainder)
    throws Exception;
*/
}

//*****************************************************************************
