//*****************************************************************************
/*
** FILE:   xm_NodeTypeEditDialog.java
**
** Copyright 1998 Steve Withall.
**
** HISTORY:
**    26Jul98  stevew  Created, based on df_DatabaseConnectDialog.
*/
package xm;

import eh.eh_Debug;

import com.sun.java.swing.Box;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JTextField;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;

//*****************************************************************************
/** A dialog for entering details about an entry to add to the node type
 *  registry.
 */
public class xm_NodeTypeEditDialog extends JDialog
{
    /** The document which will be transformed to represent the structure of
     *  the database we're looking at. */
    xm_DocumentModel  TheDocumentModel = null;

    Frame             ParentFrame      = null;

    // Attributes relating to the name of the new element.
    JLabel      ElementNameLabel             = new JLabel("Element name");
	JTextField  ElementNameTextField         = new JTextField(20);

    // Attributes relating to the description of the new element.
    JLabel      DescriptionLabel             = new JLabel("Description");
	JTextField  DescriptionTextField         = new JTextField(30);

    // Attributes relating to the name of the node class.
    JLabel      NodeClassNameLabel           = new JLabel("Node class name");
    JTextField  NodeClassNameTextField       = new JTextField(30);

    // Attributes relating to the name of the parser class.
    JLabel      ParserClassNameLabel         = new JLabel("Parser class name");
    JTextField  ParserClassNameTextField     = new JTextField(30);

    // Attributes relating to the name of the customizer class.
    JLabel      CustomizerClassNameLabel     = new JLabel("Customizer class name");
    JTextField  CustomizerClassNameTextField = new JTextField(30);

    // Attributes relating to the name of the view class.
    JLabel      ViewClassNameLabel           = new JLabel("View class name");
    JTextField  ViewClassNameTextField       = new JTextField(30);
    JLabel      ViewClassNameLabel2          = new JLabel("(Must extend com.sun.java.swing.text.View)");

    // Buttons.
    JButton     AddButton    = new JButton("Add");
    JButton     CloseButton  = new JButton("Close");

    //*****************************************************************************
    /** Constructor.
     */
    public xm_NodeTypeEditDialog(Frame             InputParentFrame,
                                 xm_DocumentModel  InputDocumentModel)
    {
	    super(InputParentFrame, "Add node type registry entry", true);
	    ParentFrame      = InputParentFrame;
        TheDocumentModel = InputDocumentModel;
	    initScreen();
	}

    //*****************************************************************************
    /** Constructor.
     */
    public xm_NodeTypeEditDialog(Frame  InputParentFrame)
    {
	    super(InputParentFrame, "Add node type registry entry", true);
	    ParentFrame = InputParentFrame;
	    initScreen();
	}

    //*****************************************************************************
    /** Initialise the screen.
     */
    protected void initScreen()
    {
	    // Load icon image.
//	    Image  IconImage = Toolkit.getDefaultToolkit().getImage("xm/images/xm_NodeTypeEditIcon.gif");
//	    InputParentFrame.setIconImage(IconImage);

        GridBagLayout      gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        getContentPane().setLayout(gbl);

        // Element name.
        gbc.anchor    = GridBagConstraints.WEST;
        gbc.gridwidth = 1;
        gbc.insets    = new Insets(0, 4, 8, 4);
        gbl.setConstraints(ElementNameLabel, gbc);
        getContentPane().add(ElementNameLabel);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(ElementNameTextField, gbc);
        getContentPane().add(ElementNameTextField);

        // Description.
        gbc.gridwidth = 1;
        gbl.setConstraints(DescriptionLabel, gbc);
        getContentPane().add(DescriptionLabel);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(DescriptionTextField, gbc);
        getContentPane().add(DescriptionTextField);

        // Node class name.
        gbc.gridwidth = 1;
        gbl.setConstraints(NodeClassNameLabel, gbc);
        getContentPane().add(NodeClassNameLabel);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(NodeClassNameTextField, gbc);
        getContentPane().add(NodeClassNameTextField);

        // Parser class name.
        gbc.gridwidth = 1;
        gbl.setConstraints(ParserClassNameLabel, gbc);
        getContentPane().add(ParserClassNameLabel);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        ParserClassNameTextField.setText(xm_NodeTypeRegistry.getDefaultParserClassName() );
        gbl.setConstraints(ParserClassNameTextField, gbc);
        getContentPane().add(ParserClassNameTextField);

        // Customizer class name.
        gbc.gridwidth = 1;
        gbl.setConstraints(CustomizerClassNameLabel, gbc);
        getContentPane().add(CustomizerClassNameLabel);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        CustomizerClassNameTextField.setText(xm_NodeTypeRegistry.getDefaultCustomizerClassName() );
        gbl.setConstraints(CustomizerClassNameTextField, gbc);
        getContentPane().add(CustomizerClassNameTextField);

        // View class name.
        gbc.gridwidth = 1;
        gbl.setConstraints(ViewClassNameLabel, gbc);
        getContentPane().add(ViewClassNameLabel);

        ViewClassNameTextField.setText(xm_NodeTypeRegistry.getDefaultViewClassName() );
        gbl.setConstraints(ViewClassNameTextField, gbc);
        getContentPane().add(ViewClassNameTextField);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(ViewClassNameLabel2, gbc);
        getContentPane().add(ViewClassNameLabel2);

	    // Panel for buttons.
        Box  ButtonBox = Box.createHorizontalBox();
        ButtonBox.add(AddButton);
        ButtonBox.add(CloseButton);

        gbc.anchor    = GridBagConstraints.EAST;
//        gbc.anchor    = GridBagConstraints.SOUTH;
        gbc.insets    = new Insets(5, 0, 0, 0);
        gbc.fill      = GridBagConstraints.HORIZONTAL;
//        gbc.gridwidth = 1;  // The number of horizontal cells  //TEMP
        gbl.setConstraints(ButtonBox, gbc);
        getContentPane().add(ButtonBox);

    	AddButton.addActionListener(new AddButtonListener() );
    	CloseButton.addActionListener(new CloseButtonListener() );

        Point  ParentLocation = ParentFrame.getLocation();
        setBounds(ParentLocation.x + 40, ParentLocation.y + 110, 770, 250);
        show();
    }

    //*****************************************************************************
    /** Pass in the document model into which we are to place the analysed structure
     *  of the database.
     *
     *  @param  InputDocumentModel  The document model to represent the database's
     *                               structure
     */
    public void setDocumentModel(xm_DocumentModel  InputDocumentModel)
    {
        TheDocumentModel = InputDocumentModel;
    }

    //*****************************************************************************
    /** Retrieve the document model into which we placed the analysed structure
     *  of the database.
     *
     *  @return  The document model representing the database's structure
     */
    public xm_DocumentModel getDocumentModel()
    {
        return TheDocumentModel;
    }

    //*****************************************************************************
    /** Retrieve the connection which was established (or null if one hasn't been
     *  established).
     *
     *  @return  The database connection which has been established
     */
//    public Connection getConnection()
//    {
//        return TheConnection;
//    }

    //*****************************************************************************
    // Button listener inner classes.
    //*****************************************************************************
    /** Handle pressing of the "Add" button. Add a registry entry for this type of
     *  element.
     */
    class AddButtonListener implements ActionListener
    {
        public void actionPerformed(ActionEvent  InputEvent)
        {
            // The name must be entered, and not already registered.
            String  ElementNameString = ElementNameTextField.getText();
            if (    ElementNameString == null
                 || ElementNameString.length() == 0)
            {
                displayError("Element name must be entered");
                return;
            }

            if (xm_NodeTypeRegistry.getDefn(ElementNameString) != null)
            {
                displayError("Element name '" + ElementNameString
                                 + "' is already registered");
                return;
            }

            // The description must be entered.
            String  DescriptionString = DescriptionTextField.getText();
            if (    DescriptionString == null
                 || DescriptionString.length() == 0)
            {
                displayError("Description must be entered");
                return;
            }

            // The node class name must be entered, and exist.
            String  NodeClassNameString = NodeClassNameTextField.getText();
            if (    NodeClassNameString == null
                 || NodeClassNameString.length() == 0)
            {
                displayError("Node class name must be entered");
                return;
            }

            // The parser class name must be entered, and exist.
            String  ParserClassNameString = ParserClassNameTextField.getText();
            if (    ParserClassNameString == null
                 || ParserClassNameString.length() == 0)
            {
                displayError("Parser class name must be entered");
                return;
            }

            // The customizer class name must be entered, and exist.
            String  CustomizerClassNameString = CustomizerClassNameTextField.getText();
            if (    CustomizerClassNameString == null
                 || CustomizerClassNameString.length() == 0)
            {
                displayError("Customizer class name must be entered");
                return;
            }

            // The view class name must be entered, and exist.
            String  ViewClassNameString = ViewClassNameTextField.getText();
            if (    ViewClassNameString == null
                 || ViewClassNameString.length() == 0)
            {
                displayError("View class name must be entered");
                return;
            }

            xm_NodeTypeRegistry.register(ElementNameString,
                                         xm_NodeTypeRegistry.UNKNOWN,
                                         DescriptionString,
                                         NodeClassNameString,
                                         ParserClassNameString,
                                         CustomizerClassNameString,
                                         ViewClassNameString);
            // Close this dialog.
            dispose();
        }

        //*****************************************************************************
        /** Display a validation error in an option dialog.
         *
         *  @param  InputErrorMessage  The text of the error message to display
         */
        public void displayError(String  InputErrorMessage)
        {
	        Object[]  MessageArray = new Object[1];
	        MessageArray[0] = InputErrorMessage;
//	        MessageArray[1] = InputException.toString();

	        String[]  OptionButtonLabel = { "OK" };
	        JOptionPane.showOptionDialog(ParentFrame,
	                                     MessageArray,
	                                     "Validation error",
	                                     JOptionPane.DEFAULT_OPTION,
	                                     JOptionPane.ERROR_MESSAGE,
	                                     null,
	                                     OptionButtonLabel,
	                                     OptionButtonLabel[0]);
//            eh_Debug.add(2, InputErrorMessage);
        }
    }

    //*****************************************************************************
    /** Handle pressing of the "Close" button. Close this dialog, and do nothing
     *  else.
     */
    class CloseButtonListener implements ActionListener
    {
        public void actionPerformed(ActionEvent  InputEvent)
        {
            dispose();
        }
    }
}
//*****************************************************************************
