//*****************************************************************************
/*
** FILE:   xm_NodeTypeDefn.java
**
** (c) 1997, 1998 Steve Withall.
**
** HISTORY:
**    08Jun98  stevew  Created, based on xe_KeywordDefn.
**    03Jul98  stevew  Moved from xe to xm.
**    24Jul98  stevew  Added ViewClassName.
*/
package xm;

import eh.eh_Debug;

//*****************************************************************************
/** The full definition of a particular type of XML node. It can be used for
 *  both 'built in' types and special types.
 */
public class xm_NodeTypeDefn
{
    /** The name of this type of node. For elements, this can be used for the
     *  element name. */
    protected String   NodeName;

    /** The type of this node. Only the fixed, pre-defined XML types should
     *  be used here.*/
    protected int      NodeType;

    /** A string representation of the type of this node (for display purposes
     * only). */
    protected String   NodeTypeString;

    /** Name of the class used to represent nodes of this type. */
    protected String   NodeClassName;

    /** Name of the class used to parse nodes of this type. */
    protected String   ParserClassName;

    /** Name of the class used for customizing (on-screen editing of) nodes of
     *  this type. */
    protected String   CustomizerClassName;

    /** Name of the class used for displaying nodes of this type (in a
     *  JEditorPane). Classes named here must be derived from swing.text.View. */
    protected String   ViewClassName;

    //*****************************************************************************
    /** Construct a node type definition.
     *
     *  @param  InputNodeName            The name of this node type
     *  @param  InputNodeType            Type of the node
     *  @param  InputNodeTypeString      String representation of the node type
     *  @param  InputNodeClassName       Name of the class used to represent nodes
     *                                    of this type
     *  @param  InputParserClassName     Name of the class used to parse nodes of
     *                                    this type
     *  @param  InputCustomizerClassName Name of the class used to customize nodes
     *                                    of this type
     *  @param  InputViewClassName       Name of the class used to display nodes
     *                                    of this type
     */
    public xm_NodeTypeDefn(String   InputNodeName,
                           int      InputNodeType,
                           String   InputNodeTypeString,
                           String   InputNodeClassName,
                           String   InputParserClassName,
                           String   InputCustomizerClassName,
                           String   InputViewClassName)
    {
        NodeName            = InputNodeName;
        NodeType            = InputNodeType;
        NodeTypeString      = InputNodeTypeString;
        NodeClassName       = InputNodeClassName;
        ParserClassName     = InputParserClassName;
        CustomizerClassName = InputCustomizerClassName;
        ViewClassName       = InputViewClassName;
    }

    //*****************************************************************************
    /** Get the name of the node.
     *
     *  @return  The name of the node
     */
    public String getName()
    {
        return NodeName;
    }

    //*****************************************************************************
    /** Get the node type.
     *
     *  @return  The node type
     */
    public int getType()
    {
        return NodeType;
    }

    //*****************************************************************************
    /** Get the string representation of the type of the node type.
     *
     *  @return  String representation of the node type
     */
    public String getTypeString()
    {
        return NodeTypeString;
    }

    //*****************************************************************************
    /** Get the name of the class used to represent nodes of this type.
     *
     *  @return  The node class name
     */
    public String getNodeClassName()
    {
        return NodeClassName;
    }

    //*****************************************************************************
    /** Get the name of the class used to parse nodes of this type.
     *
     *  @return  The parser class name
     */
    public String getParserClassName()
    {
        return ParserClassName;
    }

    //*****************************************************************************
    /** Get the name of the class used to customize nodes of this type.
     *
     *  @return  The customizer class name
     */
    public String getCustomizerClassName()
    {
        return CustomizerClassName;
    }

    //*****************************************************************************
    /** Get the name of the class used to display nodes of this type.
     *
     *  @return  The view class name
     */
    public String getViewClassName()
    {
        return ViewClassName;
    }

    //*****************************************************************************
    /** Return a string representation of this node type definition - mainly to be
     *  used for debug purposes.
     *
     *  @return  String representation of this node type definition
     */
    public String toString()
    {
        return (new String("'" + NodeName
                               + "' is node type " + NodeTypeString
                               + "(" + NodeType
                               + "), using class '" + NodeClassName
                               + "', parsed by '" + ParserClassName + "'") );
    }

    //*****************************************************************************
    /** Set the name of this node.
     *
     *  @param  InputNodeName   Name of this node
     */
    public void setName(String  InputNodeName)
    {
        NodeName = InputNodeName;
    }

    //*****************************************************************************
    /** Set the node type.
     *
     *  @param  InputNodeType   The node type
     */
    public void setType(int  InputNodeType)
    {
        NodeType = InputNodeType;
    }

    //*****************************************************************************
    /** Set the string representation of this node type.
     *
     *  @param  InputNodeTypeString   String representation of this node type
     */
    public void setTypeString(String  InputNodeTypeString)
    {
        NodeTypeString = InputNodeTypeString;
    }

    //*****************************************************************************
    /** Set the name of the class used to represent nodes of this type.
     *
     *  @param  InputNodeClassName   Name of node class
     */
    public void setNodeClassName(String  InputNodeClassName)
    {
        NodeClassName = InputNodeClassName;
    }

    //*****************************************************************************
    /** Set the name of the class used to parse nodes of this type.
     *
     *  @param  InputParserClassName   Name of parser class
     */
    public void setParserClassName(String  InputParserClassName)
    {
        ParserClassName = InputParserClassName;
    }

    //*****************************************************************************
    /** Set the name of the class used to customize nodes of this type.
     *
     *  @param  InputCustomizerClassName   Name of customizer class
     */
    public void setCustomizerClassName(String  InputCustomizerClassName)
    {
        CustomizerClassName = InputCustomizerClassName;
    }

    //*****************************************************************************
    /** Set the name of the class used to display nodes of this type.
     *
     *  @param  InputViewClassName   Name of view class
     */
    public void setViewClassName(String  InputViewClassName)
    {
        ViewClassName = InputViewClassName;
    }

    //*****************************************************************************
    /** Output this node type definition to debug.
     */
    public void listToDebug()
    {
        eh_Debug.add(1, NodeName
                          + ", " + NodeType
                          + ", " + NodeTypeString
                          + ", " + NodeClassName
                          + ", " + ParserClassName
                          + ", " + CustomizerClassName
                          + ", " + ViewClassName);
    }
}

//*****************************************************************************
