//*****************************************************************************
/*
** FILE:   xm_NodeFormatter.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24May98  stevew  Created.
**    28Jun98  stevew  Changed from interface to class.
**    05Jul98  stevew  Moved from package xg to xm.
*/
package xm;

import xg.xg_Node;

//*****************************************************************************
/** Base for all classes which reformat xg_Nodes. Reformatting in this context
 *  means replacing certain whitespace to produce a more aesthetic result when
 *  viewing an XML source - although this class could be used as the base for
 *  derived classes which perform more radical transformations on a node.
 */
abstract public class xm_NodeFormatter
{
    //*****************************************************************************
    /** Format the given node, and its children. Assume this a top-level node
     *  (typically a document).
     *
     *  @param  InputNode  The node to reformat
     */
    public void format(xg_Node  InputNode)
    {
        format(InputNode, 0);
    }

    //*****************************************************************************
    /** Format the given node, and its children.
     *
     *  @param  InputNode          The node to reformat
     *  @param  InputOpeningDepth  The depth of the node in the hierarchy. This
     *                              allows a node to be reformatted to fit in with
     *                              its surroundings (its parent and siblings). For
     *                              a top-level node, this should be 0.
     */
    abstract public void format(xg_Node  InputNode, int  InputOpeningDepth);

    //*****************************************************************************
    /** Format the children of the given node, and its children.
     *
     *  @param  InputNode          The node whose children are to be reformatted
     *  @param  InputOpeningDepth  The depth of the node in the hierarchy. This
     *                              allows a node to be reformatted to fit in with
     *                              its surroundings (its parent and siblings). For
     *                              a top-level node, this should be 0.
     */
    public void formatChildren(xg_Node  InputNode, int  InputOpeningDepth)
    {
        // The children are one level deeper - unless the InputNode is a document.
        int  NextDepthLevel = InputOpeningDepth;
        if (!(InputNode instanceof xg.xg_Document) )
            NextDepthLevel++;

        // Format each of this node's children.
        xg_Node  CurrentChild = null;
        for (int CurrentChildIndex = 0;
             CurrentChildIndex < InputNode.getChildCount();
             CurrentChildIndex++)
        {
            CurrentChild = (xg_Node)InputNode.getChildAt(CurrentChildIndex);
            format(CurrentChild, NextDepthLevel);
        }
    }
}

//*****************************************************************************
