//*****************************************************************************
/*
** FILE:   xm_FileLoader.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    07Mar98  stevew  Created, based on Swing Notepad example.
**    03Jul98  stevew  Moved from xt to xm.
**    03Jul98  stevew  Changed to inherit from xm_Thread.
*/
package xm;

import xm.xm_StatusBar;

import eh.eh_Debug;

import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;

import java.awt.Container;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

//*****************************************************************************
/** Thread to load a file into a source document.
 */
public class xm_FileLoader extends xm_Thread
{
    /** The full pathname of the file which is to be loaded. */
    String        FilePathString;

    /** The file object from which to read. */
    File          SourceFile;

    /** The document into which the file is to be read. */
    Document      SourceDocument;

    //*****************************************************************************
    /** Constructor.
     */
    public xm_FileLoader(String        InputFilePathString,
                         Document      InputSourceDocument,
                         xm_StatusBar  InputStatusBar)
    {
        super(InputStatusBar);
    	FilePathString = InputFilePathString;
    	SourceDocument = InputSourceDocument;
    }

    //*****************************************************************************
    public void run()
    {
        try
        {
    	    sleep(50);   // Avoid deadlock with focus setting code

       	    SourceFile = new File(FilePathString);
       	    if (!SourceFile.exists())
       	    {
                eh_Debug.add(3, "File " + FilePathString + " not found");
                return;
   	        }

    	    // Initialize the progress bar.
            JProgressBar  LoadProgressBar = prepareProgressBar((int)SourceFile.length(),
                                                               9,
                                                               "Loading file " + FilePathString);

            // Read the source file.
            eh_Debug.add(3, "Load file: " + FilePathString);
            Reader  SourceFileReader = new FileReader(SourceFile);
    	    char[]  ReadBuffer       = new char[4096];
            int     NumCharsRead     = 0;
            int     TotalCharCount   = 0;
            while ((NumCharsRead = SourceFileReader.read(ReadBuffer, 0, ReadBuffer.length)) != -1)
            {
                SourceDocument.insertString(SourceDocument.getLength(),
                                            new String(ReadBuffer, 0, NumCharsRead),
                                            null);
        		LoadProgressBar.setValue(LoadProgressBar.getValue() + NumCharsRead);
                TotalCharCount += NumCharsRead;
            }

            eh_Debug.add(3, "File contains " + TotalCharCount + " characters");
        }
        catch (IOException InputException)
        {
            eh_Debug.add(2, "Error opening file " + FilePathString + ". Exception = " + InputException);
        }
	    catch (InterruptedException InputException)
	    {
            eh_Debug.add(2, "Load of file " + FilePathString + "interrupted. Exception = " + InputException);
    	}
    	catch (BadLocationException InputException)
    	{
            eh_Debug.add(2, "Location of file " + FilePathString + "is bad. Exception = " + InputException);
    	}

    	removeProgressBar(9, "File " + FilePathString + " loaded");
    }
}

//*****************************************************************************
