//*****************************************************************************
/*
** FILE:   xm_Factory.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    05Jul98  stevew  Created, split from xm_NodeFactory.
*/
package xm;

import eh.eh_Debug;

import java.lang.Class;

//*****************************************************************************
/** Base factory, to provide a convenience method for checking that an actual
 *  class is derived from an class we expect it to.
 */
public class xm_Factory
{
    //*****************************************************************************
    /** Check that the InputClass is derived from InputUsualClassName.
     *
     *  @param  InputClass           The class
     *  @param  InputDescription     Description of the thing InputClass relates to
     *                                (for error reporting purposes only)
     *  @param  InputUsualClassName  The name of the class which is usually used to
     *                                represent entities of this type. The class
     *                                actually used must be this or a derived from it
     *  @exception  xm_ParseException  The InputEntityClass is not an instance of
     *                                  the class whose name is InputUsualClassName
     */
    static public void checkClassType(Class   InputClass,
                                      String  InputDescription,
                                      String  InputUsualClassName)
                                                 throws xm_ParseException
    {
        eh_Debug.add(7, "xm_Factory: Check class " + InputClass.getName()
                                 + " is derived from " + InputUsualClassName);
        Class    ParentClass    = InputClass.getSuperclass();
        boolean  FoundMatchFlag = false;
        while (!FoundMatchFlag)
        {
            if (ParentClass == null)
                throw new xm_ParseException("Cannot create '" + InputDescription
                                               + "' because its class ("
                                               + InputClass.getName()
                                               + ") is not derived from "
                                               + InputUsualClassName);

            if (InputUsualClassName.compareTo(ParentClass.getName() ) == 0)
                FoundMatchFlag = true;
            else
                ParentClass = ParentClass.getSuperclass();
        }
    }
}

//*****************************************************************************
