//*****************************************************************************
/*
** FILE:   xg_XmlDecl.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    14Apr98  stevew  Created.
*/
package xg;

import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/** An XML declaration.
*/
public class xg_XmlDecl extends xg_Node
{
    /** The version of XML to which the current document conforms, in the form
     *  "version = '1.0'". Note that this information, and the remaining values
     *  are stored in xg_Attributes because it can conveniently record all the
     *  chunks of whitespace between the components. */
    protected xg_Attribute  VersionAttribute = null;

    /** The encoding scheme in which the current document is encoded, in the
     *  form "encoding = 'UTF-8'". */
    protected xg_Attribute  EncodingAttribute = null;

    /** Specification of whether the current document is standalone, in the form
     *  "standalone = 'yes'". */
    protected xg_Attribute  StandaloneAttribute = null;

    /** The whitespace preceding the '?>' at the end. */
    protected String        WhitespacePrecedingEnd = null;

    //*****************************************************************************
    /** Default constructor.
     */
    public xg_XmlDecl()
    {
    }

    //*****************************************************************************
    /** Save this XML declaration in XML source form in InputWriter.
     *
     *  @param  InputWriter   The writer to which the XML declaration will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        eh_Debug.add(7, "xg_XmlDecl.save: Save XML declaration");  //TEMP
        if (PrecedingWhitespace != null)
            InputWriter.write(PrecedingWhitespace);
        InputWriter.write(xa_Keyword.PI_START_STRING);   // <?
        InputWriter.write(xa_Keyword.XML_STRING);        //   xml

        if (VersionAttribute != null)
            VersionAttribute.save(InputWriter);

        if (EncodingAttribute != null)
            EncodingAttribute.save(InputWriter);

        if (StandaloneAttribute != null)
            StandaloneAttribute.save(InputWriter);

        // Store and save whitespace preceding end tag.
        if (WhitespacePrecedingEnd != null)
            InputWriter.write(WhitespacePrecedingEnd);

        InputWriter.write(xa_Keyword.PI_END_STRING);     // ?>
    }

    //*****************************************************************************
    /** Set the version of this XML declaration.
     *
     *  @param  InputVersionAttribute   Attribute containing full details of the
     *                                   'version' of this XML declaration
     */
    public void setVersion(xg_Attribute  InputVersionAttribute)
    {
        VersionAttribute = InputVersionAttribute;
    }

    //*****************************************************************************
    /** Set the encoding of this XML declaration.
     *
     *  @param  InputEncodingAttribute   Attribute containing full details of the
     *                                    'encoding' of the current document
     */
    public void setEncoding(xg_Attribute  InputEncodingAttribute)
    {
        EncodingAttribute = InputEncodingAttribute;
    }

    //*****************************************************************************
    /** Set the standalone attribute of this XML declaration.
     *
     *  @param  InputStandaloneAttribute   Attribute containing full details of the
     *                                      'standalone' of this XML declaration
     */
    public void setStandalone(xg_Attribute  InputStandaloneAttribute)
    {
        StandaloneAttribute = InputStandaloneAttribute;
    }

    //*****************************************************************************
    /** Set the whitespace preceding the end tag of this XML declaration.
     *
     *  @param  InputWhitespacePrecedingEnd   Whitespace before the end
     */
    public void setWhitespacePrecedingEnd(String  InputWhitespacePrecedingEnd)
    {
        WhitespacePrecedingEnd = InputWhitespacePrecedingEnd;
    }

    //*****************************************************************************
    /** Get the type of this node.
     *
     *  @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.XML_DECL_TYPE;
    }

    //*****************************************************************************
    /** Get the type of this node, using only type values defined for the DOM.
     *  (Implements org.w3c.dom.Node.getNodeType.)
     *
     * @return  The DOM type of this node
     */
    public int getNodeType()
    {
        return xa_NodeTypeChoiceList.PI_TYPE;
    }

    //*****************************************************************************
    /** Get the version of this XML declaration.
     *
     *  @return  Attribute containing full details of the 'version' of this XML
     *            declaration
     */
    public xg_Attribute getVersion()
    {
        return VersionAttribute;
    }

    //*****************************************************************************
    /** Get the encoding of this XML declaration.
     *
     *  @return  Attribute containing full details of the 'encoding' of the current
     *            document
     */
    public xg_Attribute getEncoding()
    {
        return EncodingAttribute;
    }

    //*****************************************************************************
    /** Get the standalone attribute of this XML declaration.
     *
     *  @return  Attribute containing full details of the 'standalone' of this XML
     *            declaration
     */
    public xg_Attribute getStandalone()
    {
        return StandaloneAttribute;
    }

    //*****************************************************************************
    /** Return a string representation of the element declaration (intended for
     *  use as debug output).
     *
     *  @return  String representation of an XML declaration
     */
    public String toString()
    {
        return("XML declaration");
    }
}

//*****************************************************************************
